/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleXml {
    private boolean indentSet;
    private boolean encodingSet;
    private boolean inited;
    private PrintWriter writer;
    private TransformerHandler handler;
    private Transformer transformer;
    private StreamResult result;
    private Element currentElement;
    private Stack<Element> openElements;

    public SimpleXml(PrintWriter w) throws IOException {
        try {
            this.writer = w;
            this.handler = ((SAXTransformerFactory)SAXTransformerFactory.newInstance()).newTransformerHandler();
            this.result = new StreamResult(this.writer);
            this.openElements = new Stack();
        }
        catch (TransformerException te) {
            throw new IOException(te.getMessage());
        }
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public SimpleXml setIndent(boolean indent) {
        this.getTransformer().setOutputProperty("indent", indent ? "yes" : "no");
        this.indentSet = true;
        return this;
    }

    public SimpleXml setEncoding(String encoding) {
        this.getTransformer().setOutputProperty("encoding", encoding);
        this.encodingSet = true;
        return this;
    }

    public SimpleXml omitXmlDeclaration(boolean omit) {
        this.getTransformer().setOutputProperty("omit-xml-declaration", omit ? "yes" : "no");
        return this;
    }

    public SimpleXml setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
        return this;
    }

    public SimpleXml open() throws IOException {
        return this.openDocument();
    }

    public SimpleXml openDocument() throws IOException {
        if (!"yes".equals(this.getTransformer().getOutputProperty("omit-xml-declaration"))) {
            this.init();
            try {
                this.handler.startDocument();
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
        }
        return this;
    }

    public Element open(String name) throws IOException {
        return this.open("", "", name);
    }

    public Element open(String localName, String name) throws IOException {
        return this.open("", localName, name);
    }

    public Element open(String uri, String localName, String name) throws IOException {
        this.startElement(this.currentElement);
        this.currentElement = this.openElements.push(new Element(uri, localName, name));
        return this.currentElement;
    }

    public Element open(String name, String content, boolean cdata) throws IOException {
        Element element = this.open("", "", name);
        element.setText(content, cdata);
        return element;
    }

    public void closeDocument() throws IOException {
        this.tidyUp();
        this.init();
        if (!"yes".equals(this.getTransformer().getOutputProperty("omit-xml-declaration"))) {
            try {
                this.handler.endDocument();
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
        }
    }

    public SimpleXml close() throws IOException {
        this.endElement(this.openElements.pop());
        return this;
    }

    public SimpleXml tidyUp() throws IOException {
        while (!this.openElements.empty()) {
            Element element = this.openElements.pop();
            this.endElement(element);
        }
        return this;
    }

    private void init() {
        if (!this.inited) {
            this.handler.setResult(this.result);
            if (!this.indentSet) {
                this.setIndent(true);
            }
            if (!this.encodingSet) {
                this.setEncoding("utf-8");
            }
            this.inited = true;
        }
    }

    private Transformer getTransformer() {
        if (this.transformer == null) {
            this.transformer = this.handler.getTransformer();
        }
        return this.transformer;
    }

    private void startElement(Element element) throws IOException {
        if (element == null) {
            return;
        }
        if (!element.isOpened()) {
            this.init();
            try {
                String uri = element.getUri();
                String localName = element.getLocalName();
                String name = element.getName();
                AttributesImpl atts = element.getAttributes();
                this.handler.startElement(uri, localName, name, atts);
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
            element.setOpened(true);
        }
    }

    private void endElement(Element element) throws IOException {
        if (element == null) {
            return;
        }
        if (!element.isClosed()) {
            this.startElement(element);
            this.init();
            try {
                String uri = element.getUri();
                String localName = element.getLocalName();
                String name = element.getName();
                String content = element.getText();
                if (content != null) {
                    if (element.hasCDATA()) {
                        this.handler.startCDATA();
                    }
                    this.handler.characters(content.toCharArray(), 0, content.length());
                    if (element.hasCDATA()) {
                        this.handler.endCDATA();
                    }
                }
                this.handler.endElement(uri, localName, name);
            }
            catch (SAXException se) {
                throw new IOException(se.getMessage());
            }
            element.setClosed(true);
            this.currentElement = null;
        }
        this.openElements.remove(element);
    }

    public class Element {
        private boolean opened;
        private boolean closed;
        private boolean cdata;
        private AttributesImpl atts;
        private String uri;
        private String localName;
        private String name;
        private String text;

        protected Element(String uri, String localName, String name) {
            this.uri = uri;
            this.localName = localName;
            this.name = name;
            this.atts = new AttributesImpl();
        }

        public Element attr(String name, String value) {
            return this.attr("", "", name, value, "CDATA");
        }

        public Element attr(String localName, String name, String value) {
            return this.attr("", localName, name, value, "CDATA");
        }

        public Element attr(String uri, String localName, String name, String value, String type) {
            return this.addAttribute(uri, localName, name, value, type);
        }

        public Element attrs(String[] ... atts) {
            for (int i = 0; i < atts.length; ++i) {
                this.attr(atts[i][0], atts[i][1]);
            }
            return this;
        }

        public Element addAttribute(String uri, String localName, String name, String value, String type) {
            if (!this.opened) {
                this.atts.addAttribute(uri, localName, name, type, value);
            }
            return this;
        }

        public Element text(String text) {
            return this.text(text, false);
        }

        public Element text(String text, boolean cdata) {
            return this.setText(text, cdata);
        }

        public Element setText(String text, boolean cdata) {
            if (!this.closed) {
                this.text = text;
                this.cdata = cdata;
            }
            return this;
        }

        public Element setCDATA(boolean cdata) {
            if (!this.closed) {
                this.cdata = cdata;
            }
            return this;
        }

        public SimpleXml open() throws IOException {
            if (!this.opened) {
                SimpleXml.this.startElement(this);
            }
            return this.getWriter();
        }

        public Element open(String name) throws IOException {
            this.open();
            return this.getWriter().open(name);
        }

        public Element open(String localName, String name) throws IOException {
            this.open();
            return this.getWriter().open(localName, name);
        }

        public Element open(String uri, String localName, String name) throws IOException {
            this.open();
            return this.getWriter().open(uri, localName, name);
        }

        public Element open(String name, String content, boolean cdata) throws IOException {
            this.open();
            return this.getWriter().open(name, content, cdata);
        }

        public SimpleXml close() throws IOException {
            if (!this.closed) {
                SimpleXml.this.endElement(this);
            }
            return this.getWriter();
        }

        public boolean hasCDATA() {
            return this.cdata;
        }

        protected SimpleXml getWriter() {
            return SimpleXml.this;
        }

        protected boolean isOpened() {
            return this.opened;
        }

        protected void setOpened(boolean opened) {
            this.opened = opened;
        }

        protected boolean isClosed() {
            return this.closed;
        }

        protected void setClosed(boolean closed) {
            this.closed = closed;
        }

        protected AttributesImpl getAttributes() {
            return this.atts;
        }

        protected String getUri() {
            return this.uri;
        }

        protected String getLocalName() {
            return this.localName;
        }

        protected String getName() {
            return this.name;
        }

        protected String getText() {
            return this.text;
        }
    }
}

