/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.Language;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageUtil {
    public static final Set<String> ISO_LANGUAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOLanguages())));
    public static final Set<String> ISO_COUNTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOCountries())));
    public static final String PSEUDO_LANGUAGE = "zz";
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("/([a-zA-Z]{2})(/|$)");
    private static final Pattern DISTINCT_PATTERN = Pattern.compile("/([a-zA-Z]{2,3}_[a-zA-Z]{2,3})(/|$)");

    public static Locale getLocale(String code) {
        Language l = LanguageUtil.getLanguage(code);
        return l == null ? null : l.getLocale();
    }

    public static Language getLanguage(String code) {
        if (code == null) {
            return null;
        }
        code = code.replaceAll("-", "_");
        String lang = null;
        String country = "";
        if (code.length() == 2) {
            lang = code.toLowerCase();
        } else if (code.length() == 5 && code.charAt(2) == '_') {
            lang = code.substring(0, 2);
            country = code.substring(3);
        }
        if (lang == null) {
            return null;
        }
        if (!PSEUDO_LANGUAGE.equalsIgnoreCase(lang) && !ISO_LANGUAGES.contains(lang.toLowerCase())) {
            return null;
        }
        if (country.length() > 0 && !ISO_COUNTRIES.contains(country.toUpperCase()) && !PSEUDO_LANGUAGE.equalsIgnoreCase(lang)) {
            return null;
        }
        return new Language(lang, country);
    }

    public static String getLanguageRoot(String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return null;
        }
        String root = null;
        Matcher m = DISTINCT_PATTERN.matcher(path);
        while (m.find() && root == null) {
            String code = m.group(1);
            if (LanguageUtil.getLocale(code) == null) continue;
            root = path.substring(0, m.end(1));
        }
        if (root == null) {
            int pos = -1;
            String last = null;
            Matcher sm = SIMPLE_PATTERN.matcher(path);
            while (sm.find()) {
                String code = sm.group(1);
                if (last == null && LanguageUtil.getLocale(code) != null) {
                    last = code;
                    pos = sm.end(1);
                    continue;
                }
                if (last == null || LanguageUtil.getLocale(code + "_" + last) == null) continue;
                pos = sm.end(1);
                break;
            }
            if (pos > 0) {
                root = path.substring(0, pos);
            }
        }
        return root;
    }
}

