/*
 * Decompiled with CFR 0.152.
 */
package com.day.text;

import com.day.text.MD4;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public final class Text {
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "dd.MM.yyyy HH:mm:ss";
    private static final SimpleDateFormat dateFormatter;
    public static final TimeZone TIMEZONE_UTC;
    private static final SimpleDateFormat rfc1123Format;
    public static final TimeZone TIMEZONE_LOCAL;
    private static final String[] empty;
    private static final String MD4_HASH = "md4";
    private static final String NTLM_HASH = "ntlm";
    public static final char[] hexTable;
    public static BitSet URISave;
    public static BitSet URISaveEx;
    private static final int FLAG_LJ = 1;
    private static final int FLAG_SI = 2;
    private static final int FLAG_SP = 3;
    private static final int FLAG_ZE = 4;
    private static final int FLAG_AL = 5;
    private static final int FLAG_SHORT = 8;
    private static final int FLAG_LONG = 9;
    private static final int PARSE_STATE_NONE = 0;
    private static final int PARSE_STATE_FLAGS = 1;
    private static final int PARSE_STATE_WIDTH = 2;
    private static final int PARSE_STATE_PRECISION = 3;
    private static final int PARSE_STATE_SIZE = 4;
    private static final int PARSE_STATE_TYPE = 5;
    private static final int PARSE_STATE_END = 6;
    private static final int PARSE_STATE_ABORT = 7;
    private static final int PARSE_STATE_TERM = 8;
    private static final String[] labelCharMapping;
    public static final String NON_VALID_CHARS = "/\\:*?\"<>|\n";

    private Text() {
    }

    public static String[] split(String str, int ch) {
        return Text.explode(str, ch, false);
    }

    public static String[] split(String str, int ch, boolean respectEmpty) {
        return Text.explode(str, ch, respectEmpty);
    }

    public static String[] explode(String str, int ch) {
        return Text.explode(str, ch, false);
    }

    public static String[] explode(String str, int ch, boolean respectEmpty) {
        int pos;
        if (str == null) {
            return empty;
        }
        Vector<String> strings = new Vector<String>();
        int lastpos = 0;
        while ((pos = str.indexOf(ch, lastpos)) >= 0) {
            if (pos - lastpos > 0 || respectEmpty) {
                strings.add(str.substring(lastpos, pos));
            }
            lastpos = pos + 1;
        }
        if (lastpos < str.length()) {
            strings.add(str.substring(lastpos));
        } else if (respectEmpty && lastpos == str.length()) {
            strings.add("");
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String implode(String[] arr, String delim) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static String replace(String text, String oldString, String newString) {
        if (text == null || oldString == null || newString == null) {
            throw new IllegalArgumentException("null argument");
        }
        int pos = text.indexOf(oldString);
        if (pos == -1) {
            return text;
        }
        int lastPos = 0;
        StringBuffer sb = new StringBuffer(text.length());
        while (pos != -1) {
            sb.append(text.substring(lastPos, pos));
            sb.append(newString);
            lastPos = pos + oldString.length();
            pos = text.indexOf(oldString, lastPos);
        }
        if (lastPos < text.length()) {
            sb.append(text.substring(lastPos));
        }
        return sb.toString();
    }

    public static String getName(String path) {
        int pos = path.lastIndexOf(47);
        return pos >= 0 ? path.substring(pos + 1) : "";
    }

    public static String getName(String path, char delim) {
        int pos = path.lastIndexOf(delim);
        return pos >= 0 ? path.substring(pos + 1) : "";
    }

    public static String getName(String path, boolean ignoreTrailingSlash) {
        if (ignoreTrailingSlash && path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return Text.getName(path);
    }

    public static String getNamespacePrefix(String qname) {
        int pos = qname.indexOf(58);
        return pos >= 0 ? qname.substring(0, pos) : "";
    }

    public static String getLocalName(String qname) {
        int pos = qname.indexOf(58);
        return pos >= 0 ? qname.substring(pos + 1) : qname;
    }

    public static int compareHandles(String h1, String h2) {
        char[] ca2;
        char[] ca1 = h1.toCharArray();
        int n = ca1.length < (ca2 = h2.toCharArray()).length ? ca1.length : ca2.length;
        for (int i = 0; i < n; ++i) {
            if (ca1[i] == ca2[i]) continue;
            char c1 = ca1[i];
            char c2 = ca2[i];
            if (c1 == '/') {
                c1 = '\u0001';
            } else if (c2 == '/') {
                c2 = '\u0001';
            }
            return c1 - c2;
        }
        return ca1.length - ca2.length;
    }

    public static String fullFilePath(String parent, String path) {
        if (parent == null) {
            parent = "";
        }
        char[] source = path == null || path.length() == 0 ? parent.toCharArray() : (path.charAt(0) == '/' || path.indexOf(58) >= 0 ? path.toCharArray() : (parent + "/./" + path).toCharArray());
        return Text.makeCanonicalPath(source);
    }

    public static String fullPath(String base, String path) {
        if (base == null) {
            base = "";
        }
        char[] source = path == null || path.length() == 0 ? base.toCharArray() : (path.charAt(0) == '/' ? path.toCharArray() : (base + "/../" + path).toCharArray());
        return Text.makeCanonicalPath(source);
    }

    public static String makeCanonicalPath(String path) {
        return Text.makeCanonicalPath(path.toCharArray());
    }

    public static String makeCanonicalPath(StringBuffer source) {
        return Text.makeCanonicalPath(source.toString().toCharArray());
    }

    public static String makeCanonicalPath(char[] source) {
        int dst = 0;
        int pos = 0;
        int slash = 0;
        int dots = 0;
        int len = source.length;
        int last = 0;
        int[] slashes = new int[1024];
        int n = slashes[0] = len > 0 && source[0] == '/' ? 0 : -1;
        block4: while (pos < len) {
            int ch = source[pos++];
            switch (ch) {
                case 47: {
                    if (last == 47) continue block4;
                    if (dots == 1) {
                        dst = slashes[slash];
                    } else if (dots == 2) {
                        if (--slash < 0) {
                            slash = 0;
                        }
                        dst = slashes[slash];
                    } else {
                        slashes[++slash] = dst;
                    }
                    dots = 0;
                    break;
                }
                case 46: {
                    ++dots;
                    break;
                }
                default: {
                    dots = 3;
                }
            }
            last = ch;
            if (dst >= 0) {
                source[dst] = ch;
            }
            ++dst;
        }
        if (dots == 1) {
            dst = slashes[slash];
        } else if (dots == 2) {
            if (slash > 0) {
                --slash;
            }
            dst = slashes[slash];
        }
        return dst == 0 ? "/" : new String(source, 0, dst);
    }

    public static boolean isSibling(String h1, String h2) {
        int pos2;
        int pos1 = h1.lastIndexOf(47);
        return pos1 == (pos2 = h2.lastIndexOf(47)) && pos1 >= 0 && h1.regionMatches(0, h2, 0, pos1);
    }

    public static boolean isDescendant(String handle, String descendant) {
        return !handle.equals(descendant) && descendant.startsWith(handle) && descendant.charAt(handle.length()) == '/';
    }

    public static boolean isDescendantOrEqual(String handle, String descendant) {
        return handle.equals(descendant) || descendant.startsWith(handle) && descendant.charAt(handle.length()) == '/';
    }

    public static String getLabel(String handle) {
        int pos = handle.lastIndexOf(47);
        return pos >= 0 ? handle.substring(pos + 1) : "";
    }

    public static String getLabel(String handle, char delim) {
        int pos = handle.lastIndexOf(delim);
        return pos >= 0 ? handle.substring(pos + 1) : "";
    }

    public static String md5(String data, String enc) throws UnsupportedEncodingException {
        try {
            return Text.digest("MD5", data.getBytes(enc));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 digest not available???");
        }
    }

    public static String md5(String data) {
        try {
            return Text.digest("MD5", data.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 digest not available???");
        }
    }

    public static String digest(String algorithm, String data, String enc) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (algorithm.equalsIgnoreCase(NTLM_HASH)) {
            return Text.digest(MD4_HASH, data.getBytes("UnicodeLittleUnmarked"));
        }
        return Text.digest(algorithm, data.getBytes(enc));
    }

    public static String digest(String algorithm, String data) throws NoSuchAlgorithmException {
        return Text.digest(algorithm, data.getBytes());
    }

    public static String digest(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        byte[] digest;
        if (algorithm.equalsIgnoreCase(MD4_HASH)) {
            digest = MD4.digest(data);
        } else {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            digest = md.digest(data);
        }
        StringBuffer res = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            res.append(hexTable[b >> 4 & 0xF]);
            res.append(hexTable[b & 0xF]);
        }
        return res.toString();
    }

    public static String getRelativeParent(String handle, int level) {
        int idx = handle.length();
        while (level > 0) {
            if ((idx = handle.lastIndexOf(47, idx - 1)) < 0) {
                return "";
            }
            --level;
        }
        return handle.substring(0, idx);
    }

    public static String getAbsoluteParent(String handle, int level) {
        int idx = 0;
        int len = handle.length();
        while (level >= 0 && idx < len) {
            if ((idx = handle.indexOf(47, idx + 1)) < 0) {
                idx = len;
            }
            --level;
        }
        return level >= 0 ? "" : handle.substring(0, idx);
    }

    public static String escape(String string, char escape) {
        return Text.escape(string, escape, false);
    }

    public static String escape(String string, char escape, boolean isPath) {
        try {
            BitSet validChars = isPath ? URISaveEx : URISave;
            byte[] bytes = string.getBytes("utf-8");
            StringBuffer out = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                int c = bytes[i] & 0xFF;
                if (validChars.get(c) && c != escape) {
                    out.append((char)c);
                    continue;
                }
                out.append(escape);
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public static String escape(String string) {
        return Text.escape(string, '%');
    }

    public static String escapePath(String path) {
        return Text.escape(path, '%', true);
    }

    public static String unescape(String string, char escape) {
        int pos;
        ByteArrayOutputStream out = new ByteArrayOutputStream(string.length() * 2);
        int lastPos = 0;
        while ((pos = string.indexOf(escape, lastPos)) >= 0) {
            try {
                out.write(string.substring(lastPos, pos).getBytes("utf-8"));
            }
            catch (IOException e) {
                throw new InternalError(e.toString());
            }
            lastPos = pos + 3;
            if (lastPos > string.length()) continue;
            try {
                out.write(Integer.parseInt(string.substring(pos + 1, lastPos), 16));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        if (lastPos >= 0 && lastPos <= string.length()) {
            try {
                out.write(string.substring(lastPos).getBytes("utf-8"));
            }
            catch (IOException e) {
                throw new InternalError(e.toString());
            }
        }
        try {
            return new String(out.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    public static String unescape(String string) {
        return Text.unescape(string, '%');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToRfc1123String(Date date) {
        SimpleDateFormat simpleDateFormat = rfc1123Format;
        synchronized (simpleDateFormat) {
            return rfc1123Format.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String strftime(Date date, String formatPattern, TimeZone zone) {
        formatPattern = formatPattern == null || formatPattern.length() == 0 ? DEFAULT_DATE_FORMAT_PATTERN : Text.convertFormat(formatPattern);
        if (zone == null) {
            zone = TIMEZONE_LOCAL;
        }
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            dateFormatter.applyPattern(formatPattern);
            dateFormatter.setTimeZone(zone);
            return dateFormatter.format(date);
        }
    }

    public static String strftime(Date date, String formatPattern, boolean asUTC) {
        return Text.strftime(date, formatPattern, asUTC ? TIMEZONE_UTC : TIMEZONE_LOCAL);
    }

    public static String strftime(Date date, boolean asUTC) {
        return Text.strftime(date, null, asUTC);
    }

    public static String strftime(Date date) {
        return Text.strftime(date, null, false);
    }

    public static Date parseDate(String dateString, String formatPattern) throws ParseException {
        return Text.parseDate(dateString, formatPattern, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String dateString, String formatPattern, boolean isUTC) throws ParseException {
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            dateFormatter.applyPattern(formatPattern);
            if (isUTC) {
                dateFormatter.setTimeZone(TIMEZONE_UTC);
            } else {
                dateFormatter.setTimeZone(TimeZone.getDefault());
            }
            return dateFormatter.parse(dateString);
        }
    }

    public static Date parseDate(String dateString) throws ParseException {
        return Text.parseDate(dateString, DEFAULT_DATE_FORMAT_PATTERN, false);
    }

    public static Date parseDate(String dateString, boolean isUTC) throws ParseException {
        return Text.parseDate(dateString, DEFAULT_DATE_FORMAT_PATTERN, isUTC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String sprintf(String format, Object[] args) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (format.length() == 0) {
            return "";
        }
        char[] s = format.toCharArray();
        StringBuffer res = new StringBuffer(s.length * 3 / 2);
        int i = 0;
        int j = 0;
        int length = format.length();
        while (i < length) {
            int parse_state = 0;
            BitSet flags = new BitSet(16);
            int width = 0;
            int precision = -1;
            char fmt = ' ';
            while (parse_state == 0) {
                if (i >= length) {
                    parse_state = 8;
                } else if (s[i] == '%') {
                    if (i >= length - 1) throw new IllegalArgumentException("Incomplete format at end of format string");
                    if (s[i + 1] == '%') {
                        res.append('%');
                        ++i;
                    } else {
                        parse_state = 1;
                    }
                } else {
                    res.append(s[i]);
                }
                ++i;
            }
            while (parse_state == 1) {
                if (i >= length) {
                    parse_state = 7;
                } else if (s[i] == ' ') {
                    flags.set(3);
                } else if (s[i] == '-') {
                    flags.set(1);
                } else if (s[i] == '+') {
                    flags.set(2);
                } else if (s[i] == '0') {
                    flags.set(4);
                } else if (s[i] == '#') {
                    flags.set(5);
                } else {
                    parse_state = 2;
                    --i;
                }
                ++i;
            }
            while (parse_state == 2) {
                if (i >= length) {
                    parse_state = 7;
                    continue;
                }
                if ('0' <= s[i] && s[i] <= '9') {
                    width = width * 10 + s[i] - 48;
                    ++i;
                    continue;
                }
                if (s[i] == '*') {
                    if (j >= args.length) {
                        throw new IllegalArgumentException("Missing argument for the width");
                    }
                    try {
                        width = ((Number)args[j++]).intValue();
                    }
                    catch (ClassCastException cce) {
                        throw new IllegalArgumentException("Width argument is not numeric");
                    }
                    ++i;
                }
                if (s[i] == '.') {
                    parse_state = 3;
                    precision = 0;
                    ++i;
                    continue;
                }
                parse_state = 4;
            }
            while (parse_state == 3) {
                if (i >= length) {
                    parse_state = 7;
                    continue;
                }
                if ('0' <= s[i] && s[i] <= '9') {
                    precision = precision * 10 + s[i] - 48;
                    ++i;
                    continue;
                }
                if (s[i] == '*') {
                    if (j >= args.length) {
                        throw new IllegalArgumentException("Missing argument for the precision");
                    }
                    try {
                        width = ((Number)args[j++]).intValue();
                    }
                    catch (ClassCastException cce) {
                        throw new IllegalArgumentException("Precision argument is not numeric");
                    }
                    ++i;
                }
                parse_state = 4;
            }
            if (parse_state == 4) {
                if (i >= length) {
                    parse_state = 6;
                } else {
                    if (s[i] == 'h') {
                        flags.set(8);
                        ++i;
                    } else if (s[i] == 'l' || s[i] == 'L') {
                        flags.set(9);
                        ++i;
                    }
                    parse_state = 5;
                }
            }
            if (parse_state == 5) {
                if (i >= length) {
                    parse_state = 7;
                } else {
                    fmt = s[i];
                    ++i;
                    parse_state = 6;
                }
            }
            if (parse_state == 6) {
                if (j >= args.length) {
                    throw new IllegalArgumentException("Not enough parameters for the format string");
                }
                try {
                    switch (fmt) {
                        case 'X': 
                        case 'd': 
                        case 'i': 
                        case 'o': 
                        case 'u': 
                        case 'x': {
                            Text.format(res, (Number)args[j], fmt, width, precision, flags);
                            break;
                        }
                        case 'E': 
                        case 'G': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            Text.format(res, ((Number)args[j]).doubleValue(), fmt, width, precision, flags);
                            break;
                        }
                        case 'c': {
                            precision = 1;
                        }
                        case 's': {
                            String val = args[j].toString();
                            if (val.length() > precision && precision > 0) {
                                val = val.substring(0, precision);
                            }
                            flags.clear(4);
                            Text.format(res, val, "", width, flags);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown conversion type " + fmt);
                        }
                    }
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("sprintf: Argument #" + j + " of type " + args[j].getClass().getName() + " does not match format " + fmt);
                }
                ++j;
            }
            if (parse_state != 7) continue;
            throw new IllegalArgumentException("Incomplete format at end of format string");
        }
        return res.toString();
    }

    public static String sprintf(String format, Object a0) {
        return Text.sprintf(format, new Object[]{a0});
    }

    public static String sprintf(String format, Object a0, Object a1) {
        return Text.sprintf(format, new Object[]{a0, a1});
    }

    public static String sprintf(String format, Object a0, Object a1, Object a2) {
        return Text.sprintf(format, new Object[]{a0, a1, a2});
    }

    public static String sprintf(String format, Object a0, Object a1, Object a2, Object a3) {
        return Text.sprintf(format, new Object[]{a0, a1, a2, a3});
    }

    public static String sprintf(String format, Object a0, Object a1, Object a2, Object a3, Object a4) {
        return Text.sprintf(format, new Object[]{a0, a1, a2, a3, a4});
    }

    public static String createValidLabel(String labelhint) {
        char[] chrs = labelhint.toCharArray();
        StringBuffer labelbase = new StringBuffer(chrs.length);
        for (int idx = 0; idx < chrs.length && labelbase.length() < 64; ++idx) {
            char c = chrs[idx];
            String repl = "_";
            if (c >= '\u0000' && c < labelCharMapping.length) {
                repl = labelCharMapping[c];
            }
            if (repl.equals("_") && labelbase.length() > 16) break;
            labelbase.append(repl);
        }
        return labelbase.toString();
    }

    public static void validateLabel(String labelhint) {
        if (labelhint == null || labelhint.equals("")) {
            throw new IllegalArgumentException("Exact Label must not be empty.");
        }
        if (".".equals(labelhint) || "..".equals(labelhint)) {
            throw new IllegalArgumentException("Exact Label must not be ''.'' or ''..''");
        }
        for (int idx = 0; idx < labelhint.length(); ++idx) {
            if (NON_VALID_CHARS.indexOf(labelhint.charAt(idx)) < 0 && labelhint.charAt(idx) <= '\u007f') continue;
            throw new IllegalArgumentException("Exact Label contains illegal character: '" + labelhint.charAt(idx) + "'");
        }
    }

    private static String convertFormat(String posixFormat) {
        char[] format = posixFormat.toCharArray();
        StringBuffer jFormat = new StringBuffer(format.length);
        boolean inString = false;
        block34: for (int i = 0; i < format.length; ++i) {
            if (format[i] == '\'') {
                jFormat.append('\'');
                continue;
            }
            if (format[i] == '%') {
                if (inString) {
                    jFormat.append('\'');
                    inString = false;
                }
                switch (format[++i]) {
                    case '%': {
                        jFormat.append('%');
                        break;
                    }
                    case 'a': {
                        jFormat.append("EEE");
                        break;
                    }
                    case 'A': {
                        jFormat.append("EEEE");
                        break;
                    }
                    case 'b': {
                        jFormat.append("MMM");
                        break;
                    }
                    case 'B': {
                        jFormat.append("MMMM");
                        break;
                    }
                    case 'c': {
                        break;
                    }
                    case 'C': {
                        break;
                    }
                    case 'd': {
                        jFormat.append("dd");
                        break;
                    }
                    case 'D': {
                        jFormat.append("MM/dd/yy");
                        break;
                    }
                    case 'e': {
                        jFormat.append("d");
                        break;
                    }
                    case 'h': {
                        jFormat.append("MMM");
                        break;
                    }
                    case 'H': {
                        jFormat.append("HH");
                        break;
                    }
                    case 'I': {
                        jFormat.append("hh");
                        break;
                    }
                    case 'j': {
                        jFormat.append("DDD");
                        break;
                    }
                    case 'K': {
                        if (format[++i] != 'C') continue block34;
                        break;
                    }
                    case 'm': {
                        jFormat.append("MM");
                        break;
                    }
                    case 'M': {
                        jFormat.append("mm");
                        break;
                    }
                    case 'n': {
                        jFormat.append(System.getProperty("line.separator", "\n"));
                        break;
                    }
                    case 'p': {
                        jFormat.append("aa");
                        break;
                    }
                    case 'r': {
                        jFormat.append("hh:mm:ss aa");
                        break;
                    }
                    case 'R': {
                        jFormat.append("hh:mm");
                        break;
                    }
                    case 'S': {
                        jFormat.append("ss");
                        break;
                    }
                    case 't': {
                        jFormat.append('\t');
                        break;
                    }
                    case 'T': {
                        jFormat.append("HH:mm:ss");
                        break;
                    }
                    case 'U': {
                        jFormat.append("ww");
                        break;
                    }
                    case 'w': {
                        jFormat.append("E");
                        break;
                    }
                    case 'W': {
                        jFormat.append("ww");
                        break;
                    }
                    case 'x': {
                        break;
                    }
                    case 'X': {
                        break;
                    }
                    case 'y': {
                        jFormat.append("yy");
                        break;
                    }
                    case 'Y': {
                        jFormat.append("yyyy");
                        break;
                    }
                    case 'Z': {
                        jFormat.append("zzz");
                        break;
                    }
                }
                continue;
            }
            if (Character.isLetterOrDigit(format[i])) {
                if (!inString) {
                    inString = true;
                    jFormat.append('\'');
                }
                jFormat.append(format[i]);
                continue;
            }
            jFormat.append(format[i]);
        }
        if (inString) {
            jFormat.append('\'');
        }
        return jFormat.toString();
    }

    private static StringBuffer format(StringBuffer buf, Number num, char fmt, int width, int precision, BitSet flags) {
        String numStr;
        long sizeMask;
        long val;
        boolean toUpper;
        String prefStr = "";
        boolean bl = toUpper = fmt == 'X';
        if (precision >= 0) {
            flags.clear(4);
        } else {
            precision = 1;
        }
        if (flags.get(8)) {
            val = num.shortValue();
            sizeMask = 65535L;
        } else if (flags.get(9)) {
            val = num.longValue();
            sizeMask = -1L;
        } else {
            val = num.intValue();
            sizeMask = 0xFFFFFFFFL;
        }
        if (fmt == 'x' || fmt == 'X') {
            numStr = Long.toHexString(val & sizeMask);
            if (toUpper) {
                numStr = numStr.toUpperCase();
            }
            if (flags.get(5)) {
                prefStr = toUpper ? "0X" : "0x";
            }
        } else if (fmt == 'o') {
            numStr = Long.toOctalString(val & sizeMask);
            if (flags.get(5) && val != 0L && precision <= numStr.length()) {
                precision = numStr.length() + 1;
            }
        } else {
            numStr = Long.toString(val);
            if (val < 0L) {
                prefStr = "-";
                numStr = numStr.substring(1);
            } else if (flags.get(2)) {
                prefStr = "+";
            }
        }
        if (precision > numStr.length()) {
            StringBuffer tmp = new StringBuffer(precision);
            precision -= numStr.length();
            while (precision > 0) {
                tmp.append('0');
                --precision;
            }
            numStr = tmp.append(numStr).toString();
        }
        return Text.format(buf, numStr, prefStr, width, flags);
    }

    private static StringBuffer format(StringBuffer buf, double num, char fmt, int width, int precision, BitSet flags) {
        BigDecimal val = new BigDecimal(num).abs();
        char expChar = '\u0000';
        int exp = fmt != 'f' ? val.unscaledValue().toString().length() - val.scale() - 1 : 0;
        boolean needDot = precision == 0 && flags.get(5);
        boolean checkTrails = false;
        if (precision < 0) {
            precision = 6;
        }
        switch (fmt) {
            case 'G': 
            case 'g': {
                if (precision > 0) {
                    --precision;
                }
                checkTrails = true;
                if (exp <= precision) {
                    precision -= exp;
                    break;
                }
            }
            case 'E': 
            case 'e': {
                val = val.movePointLeft(exp);
                char c = expChar = fmt == 'e' || fmt == 'g' ? (char)'e' : 'E';
            }
        }
        if (precision >= 0) {
            val = val.setScale(precision, 4);
        }
        String numStr = val.toString();
        if (checkTrails) {
            if (flags.get(5)) {
                needDot |= numStr.indexOf(46) < 0;
            } else {
                int dot = numStr.indexOf(46);
                if (dot >= 0) {
                    int i;
                    for (i = numStr.length() - 1; i >= dot && numStr.charAt(i) == '0'; --i) {
                    }
                    if (i > dot) {
                        ++i;
                    }
                    numStr = numStr.substring(0, i);
                }
            }
        }
        StringBuffer numBuf = new StringBuffer(numStr);
        if (needDot) {
            numBuf.append('.');
        }
        if (expChar != '\u0000') {
            numBuf.append(expChar);
            numBuf.append(exp < 0 ? (char)'-' : '+');
            if (exp < 10) {
                numBuf.append('0');
            }
            numBuf.append(exp);
        }
        String prefStr = num < 0.0 ? "-" : (flags.get(2) ? "+" : "");
        return Text.format(buf, numBuf.toString(), prefStr, width, flags);
    }

    private static StringBuffer format(StringBuffer buf, String str, String prefStr, int width, BitSet flags) {
        int numFill = width - prefStr.length() - str.length();
        int preZero = 0;
        int preBlank = 0;
        int postBlank = 0;
        if (flags.get(1)) {
            postBlank = numFill;
        } else if (flags.get(4)) {
            preZero = numFill;
        } else {
            preBlank = numFill;
        }
        while (preBlank > 0) {
            buf.append(' ');
            --preBlank;
        }
        buf.append(prefStr);
        while (preZero > 0) {
            buf.append('0');
            --preZero;
        }
        buf.append(str);
        while (postBlank > 0) {
            buf.append(' ');
            --postBlank;
        }
        return buf;
    }

    public static String joinFixSlash(String first, String second) {
        int i;
        StringBuffer result = new StringBuffer(first.startsWith("/") ? "/" : "");
        String[] firstSplit = Text.explode(first, 47);
        String[] secondSplit = Text.explode(second, 47);
        for (i = 0; i < firstSplit.length; ++i) {
            result.append(firstSplit[i]).append("/");
        }
        for (i = 0; i < secondSplit.length; ++i) {
            result.append(secondSplit[i]).append("/");
        }
        if (result.length() > 1) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public static String replaceVariables(Properties variables, String value, boolean ignoreMissing) throws IllegalArgumentException {
        StringBuffer result = new StringBuffer();
        int p = 0;
        int q = value.indexOf("${");
        while (q != -1) {
            result.append(value.substring(p, q));
            p = q;
            if ((q = value.indexOf("}", q + 2)) == -1) continue;
            String variable = value.substring(p + 2, q);
            String replacement = variables.getProperty(variable);
            if (replacement == null) {
                if (ignoreMissing) {
                    replacement = "";
                } else {
                    throw new IllegalArgumentException("Replacement not found for ${" + variable + "}.");
                }
            }
            result.append(replacement);
            p = q + 1;
            q = value.indexOf("${", p);
        }
        result.append(value.substring(p, value.length()));
        return result.toString();
    }

    static {
        int i;
        dateFormatter = new SimpleDateFormat();
        TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
        rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", Locale.US);
        rfc1123Format.setTimeZone(TIMEZONE_UTC);
        TIMEZONE_LOCAL = TimeZone.getDefault();
        empty = new String[0];
        hexTable = "0123456789abcdef".toCharArray();
        URISave = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URISave.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URISave.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URISave.set(i);
        }
        URISave.set(45);
        URISave.set(95);
        URISave.set(46);
        URISave.set(33);
        URISave.set(126);
        URISave.set(42);
        URISave.set(39);
        URISave.set(40);
        URISave.set(41);
        URISaveEx = (BitSet)URISave.clone();
        URISaveEx.set(47);
        labelCharMapping = new String[]{"_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "-", "_", "_", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_", "_", "_", "_", "_", "_", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_", "_", "_", "_", "_", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_", "_", "_", "_", "_", "_", "f", "_", "_", "_", "fi", "fi", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "y", "_", "_", "_", "_", "i", "c", "p", "o", "v", "_", "s", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "a", "a", "a", "a", "ae", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "d", "n", "o", "o", "o", "o", "oe", "x", "o", "u", "u", "u", "ue", "y", "b", "ss", "a", "a", "a", "a", "ae", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "o", "n", "o", "o", "o", "o", "oe", "_", "o", "u", "u", "u", "ue", "y", "b", "y"};
    }
}

