/*
 * Decompiled with CFR 0.152.
 */
package com.day.any;

import com.day.any.AnyNode;
import java.io.IOException;
import java.io.Writer;

public class AnyValue
extends AnyNode {
    private double numberValue = 0.0;
    private String stringValue = "";

    public AnyValue() {
    }

    public AnyValue(String label) {
        super(label);
    }

    public AnyValue(String label, double value) {
        super(label);
        this.setValue(value);
    }

    public AnyValue(String label, String value) {
        super(label);
        this.setValue(value);
    }

    public void setValue(double value) {
        this.numberValue = value;
        this.stringValue = null;
    }

    public void setValue(String value) {
        this.stringValue = value;
    }

    public String getValue() {
        return this.stringValue;
    }

    public String getStringValue() {
        return this.stringValue == null ? String.valueOf(this.numberValue) : this.stringValue;
    }

    public double getNumberValue() {
        try {
            return this.stringValue == null ? this.numberValue : Double.parseDouble(this.stringValue);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.getLabel().equals("")) {
            buffer.append('/');
            buffer.append(this.getLabel());
        }
        buffer.append(' ');
        if (this.stringValue == null) {
            if (Math.floor(this.numberValue) == this.numberValue) {
                buffer.append((int)this.numberValue);
            } else {
                buffer.append(this.numberValue);
            }
        } else {
            buffer.append('\"');
            char[] chars = this.stringValue.toCharArray();
            block7: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case '\t': {
                        buffer.append("\\t");
                        continue block7;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        buffer.append("\\r");
                        continue block7;
                    }
                    case '\"': {
                        buffer.append("\\\"");
                        continue block7;
                    }
                    case '\\': {
                        buffer.append("\\\\");
                        continue block7;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public void write(Writer out, int indent) throws IOException {
        out.write(AnyNode.SPACES, 0, indent);
        out.write(this.toString().toCharArray());
        out.write(10);
    }

    public boolean isNumber() {
        return this.stringValue == null;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean isValue() {
        return true;
    }
}

