/*
 * Decompiled with CFR 0.152.
 */
package com.dawnimpulse.auth.providers;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import com.dawnimpulse.auth.R;
import com.dawnimpulse.auth.utils.Config;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\u00020\u00072\u001c\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00070\u0006J$\u0010\u000f\u001a\u00020\u00072\u001c\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00070\u0006R$\u0010\u0005\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dawnimpulse/auth/providers/AuthGoogle;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callback", "Lkotlin/Function2;", "", "googleSignInClient", "Lcom/google/android/gms/auth/api/signin/GoogleSignInClient;", "getSignedInUser", "Lcom/google/android/gms/auth/api/signin/GoogleSignInAccount;", "isUserSignedIn", "", "signIn", "signOut", "Inner", "auth_debug"})
public final class AuthGoogle {
    private Context context;
    private GoogleSignInClient googleSignInClient;
    private Function2<Object, Object, Unit> callback;

    public final void signIn(@NotNull Function2<Object, Object, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Config.INSTANCE.setCallback(callback);
        Config.INSTANCE.setGoogleSignInClient(this.googleSignInClient);
        Context context = this.context;
        if (context == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.support.v7.app.AppCompatActivity");
        }
        ((AppCompatActivity)context).startActivity(new Intent(this.context, Inner.class));
    }

    public final void signOut(@NotNull Function2<Object, Object, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.googleSignInClient.signOut().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(callback){
            final /* synthetic */ Function2 $callback;

            public final void onComplete(@NotNull Task<Void> task) {
                Intrinsics.checkParameterIsNotNull(task, (String)"task");
                if (task.isComplete()) {
                    Log.d((String)"Auth-Android", (String)"Successfully Signed Out");
                    this.$callback.invoke(null, (Object)true);
                } else if (task.getException() == null) {
                    Log.d((String)"Auth-Android", (String)String.valueOf(task.getException()));
                    this.$callback.invoke((Object)task.getException(), null);
                } else {
                    Log.d((String)"Auth-Android", (String)String.valueOf(task.getException()));
                    this.$callback.invoke((Object)"Task Failed", null);
                }
            }
            {
                this.$callback = function2;
            }
        });
    }

    public final boolean isUserSignedIn() {
        return GoogleSignIn.getLastSignedInAccount((Context)this.context) != null;
    }

    @Nullable
    public final GoogleSignInAccount getSignedInUser() {
        return GoogleSignIn.getLastSignedInAccount((Context)this.context);
    }

    public AuthGoogle(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().build();
        GoogleSignInClient googleSignInClient = GoogleSignIn.getClient((Context)context, (GoogleSignInOptions)gso);
        Intrinsics.checkExpressionValueIsNotNull((Object)googleSignInClient, (String)"GoogleSignIn.getClient(context, gso)");
        this.googleSignInClient = googleSignInClient;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\"\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dawnimpulse/auth/providers/AuthGoogle$Inner;", "Landroid/support/v7/app/AppCompatActivity;", "()V", "CODE_SIGN_IN", "", "handleSignInResult", "", "completedTask", "Lcom/google/android/gms/tasks/Task;", "Lcom/google/android/gms/auth/api/signin/GoogleSignInAccount;", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "auth_debug"})
    public static final class Inner
    extends AppCompatActivity {
        private final int CODE_SIGN_IN = 0;
        private HashMap _$_findViewCache;

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.setContentView(R.layout.transparent_layout);
            this.startActivityForResult(Config.INSTANCE.getGoogleSignInClient().getSignInIntent(), this.CODE_SIGN_IN);
        }

        protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            super.onActivityResult(requestCode, resultCode, data);
            if (requestCode == this.CODE_SIGN_IN) {
                Task task = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
                Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"GoogleSignIn.getSignedInAccountFromIntent(data)");
                this.handleSignInResult((Task<GoogleSignInAccount>)task);
            }
        }

        private final void handleSignInResult(Task<GoogleSignInAccount> completedTask) {
            try {
                GoogleSignInAccount account = (GoogleSignInAccount)completedTask.getResult(ApiException.class);
                StringBuilder stringBuilder = new StringBuilder().append("SIGNED IN - ");
                GoogleSignInAccount googleSignInAccount = account;
                Intrinsics.checkExpressionValueIsNotNull((Object)googleSignInAccount, (String)"account");
                Log.d((String)"Auth-Android", (String)stringBuilder.append(googleSignInAccount.getDisplayName()).toString());
                Config.INSTANCE.getCallback().invoke(null, (Object)account);
                this.finish();
            }
            catch (ApiException e) {
                Log.d((String)"Auth-Android", (String)("signInResult:failed code=" + e.getStatusCode()));
                Config.INSTANCE.getCallback().invoke((Object)("signInResult:failed code=" + e.getStatusCode()), null);
                this.finish();
            }
        }

        public View _$_findCachedViewById(int n) {
            View view;
            if (this._$_findViewCache == null) {
                this._$_findViewCache = new HashMap();
            }
            if ((view = (View)this._$_findViewCache.get(n)) == null) {
                view = this.findViewById(n);
                this._$_findViewCache.put(n, view);
            }
            return view;
        }

        public void _$_clearFindViewByIdCache() {
            if (this._$_findViewCache != null) {
                this._$_findViewCache.clear();
            }
        }
    }
}

