/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff;

import com.davidehrmann.vcdiff.VCDiffDecoder;
import com.davidehrmann.vcdiff.VCDiffStreamingDecoder;
import com.davidehrmann.vcdiff.engine.VCDiffStreamingDecoderImpl;
import com.davidehrmann.vcdiff.io.VCDiffInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class VCDiffDecoderBuilder {
    protected long maximumTargetFileSize = -1L;
    protected int maximumTargetWindowSize = -1;
    protected boolean allowTargetMatches = true;

    protected VCDiffDecoderBuilder() {
    }

    public synchronized VCDiffDecoderBuilder withMaxTargetFileSize(long maximumTargetFileSize) {
        if (maximumTargetFileSize < 0L) {
            throw new IllegalArgumentException("maximumTargetFileSize can't be negative");
        }
        this.maximumTargetFileSize = maximumTargetFileSize;
        return this;
    }

    public synchronized VCDiffDecoderBuilder withMaxTargetWindowSize(int maximumTargetWindowSize) {
        if (maximumTargetWindowSize < 0) {
            throw new IllegalArgumentException("maximumTargetWindowSize can't be negative");
        }
        this.maximumTargetWindowSize = maximumTargetWindowSize;
        return this;
    }

    public synchronized VCDiffDecoderBuilder withAllowTargetMatches(boolean allowTargetMatches) {
        this.allowTargetMatches = allowTargetMatches;
        return this;
    }

    public VCDiffStreamingDecoder buildStreaming() {
        return this.buildStreaming(new VCDiffStreamingDecoderImpl());
    }

    public synchronized VCDiffStreamingDecoder buildStreaming(VCDiffStreamingDecoder decoder) {
        if (this.maximumTargetFileSize >= 0L) {
            decoder.setMaximumTargetFileSize(this.maximumTargetFileSize);
        }
        if (this.maximumTargetWindowSize >= 0) {
            decoder.setMaximumTargetWindowSize(this.maximumTargetWindowSize);
        }
        decoder.setAllowVcdTarget(this.allowTargetMatches);
        return decoder;
    }

    public VCDiffInputStream buildInputStream(InputStream in, byte[] dictionary) {
        return this.buildInputStream(in, ByteBuffer.wrap(dictionary));
    }

    public VCDiffInputStream buildInputStream(InputStream in, ByteBuffer dictionary) {
        return new VCDiffInputStream(in, dictionary, this.buildStreaming());
    }

    public VCDiffDecoder buildSimple() {
        return new VCDiffDecoder(this.buildStreaming());
    }

    public VCDiffDecoder buildSimple(VCDiffStreamingDecoder decoder) {
        return new VCDiffDecoder(this.buildStreaming(decoder));
    }

    public static VCDiffDecoderBuilder builder() {
        return new VCDiffDecoderBuilder();
    }
}

