/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.io;

import com.davidehrmann.vcdiff.VCDiffDecoderBuilder;
import com.davidehrmann.vcdiff.VCDiffStreamingDecoder;
import com.davidehrmann.vcdiff.util.Objects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class VCDiffInputStream
extends InputStream {
    public static final int DEFAULT_MAX_TARGET_FILE_SIZE = 0x4000000;
    public static final int DEFAULT_MAX_TARGET_WINDOW_SIZE = 0x4000000;
    public static final boolean DEFAULT_ALLOW_VCD_TARGET = false;
    private final VCDiffStreamingDecoder decoder;
    private final byte[] dictionary;
    private final InputStream in;
    private final byte[] inBuffer = new byte[4096];
    private volatile long totalBytesRead = 0L;
    private volatile ByteBuffer decodedBuffer = ByteBuffer.allocate(0);
    private final ByteArrayOutputStream tempDecoded = new ByteArrayOutputStream();
    private volatile boolean decodingStarted = false;
    private volatile boolean closed = false;

    public VCDiffInputStream(InputStream in, byte[] dictionary) {
        this(in, dictionary, 0x4000000L, 0x4000000, false);
    }

    public VCDiffInputStream(InputStream in, byte[] dictionary, long maxTargetFileSize, int maxTargetWindowSize, boolean allowVcdTarget) {
        this.in = Objects.requireNotNull(in, "in was null");
        this.dictionary = (byte[])Objects.requireNotNull(dictionary, "dictionary was null").clone();
        this.decoder = VCDiffDecoderBuilder.builder().withMaxTargetFileSize(maxTargetFileSize).withMaxTargetWindowSize(maxTargetWindowSize).withAllowTargetMatches(allowVcdTarget).buildStreaming();
    }

    public VCDiffInputStream(InputStream in, byte[] dictionary, VCDiffStreamingDecoder decoder) {
        this.in = Objects.requireNotNull(in, "in was null");
        this.decoder = Objects.requireNotNull(decoder, "decoder was null");
        this.dictionary = (byte[])Objects.requireNotNull(dictionary, "dictionary was null").clone();
    }

    @Override
    public int read() throws IOException {
        this.fillDecodedBuffer();
        if (this.decodedBuffer.hasRemaining()) {
            return this.decodedBuffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.fillDecodedBuffer();
        if (this.decodedBuffer.hasRemaining()) {
            int lenToCopy = Math.min(len, this.decodedBuffer.remaining());
            this.decodedBuffer.get(b, off, lenToCopy);
            return lenToCopy;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        for (skipped = 0L; skipped < n; skipped += (long)this.decodedBuffer.remaining()) {
            this.fillDecodedBuffer();
            if (!this.decodedBuffer.hasRemaining()) {
                return skipped;
            }
            if (skipped + (long)this.decodedBuffer.remaining() < n) {
                this.decodedBuffer.position(this.decodedBuffer.position() + this.decodedBuffer.remaining());
                continue;
            }
            this.decodedBuffer.position(this.decodedBuffer.position() + (int)(n - skipped));
            return n;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.decodedBuffer.remaining();
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void fillDecodedBuffer() throws IOException {
        if (this.closed) {
            throw new IOException("InputStream is closed");
        }
        while (!this.decodedBuffer.hasRemaining()) {
            int read = this.in.read(this.inBuffer);
            if (read >= 0) {
                this.totalBytesRead += (long)read;
                if (!this.decodingStarted) {
                    this.decoder.startDecoding(this.dictionary);
                    this.decodingStarted = true;
                }
                try {
                    this.decoder.decodeChunk(this.inBuffer, 0, read, this.tempDecoded);
                }
                catch (IOException e) {
                    throw new IOException("Error trying to decode data chunk starting at offset " + (this.totalBytesRead - (long)read), e);
                }
                if (this.tempDecoded.size() <= 0) continue;
                this.decodedBuffer = ByteBuffer.wrap(this.tempDecoded.toByteArray());
                this.tempDecoded.reset();
                continue;
            }
            this.decoder.finishDecoding();
            break;
        }
    }
}

