/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.engine.VCDiffCodeTableData;
import com.davidehrmann.vcdiff.util.Objects;
import com.davidehrmann.vcdiff.util.VarInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class VCDiffCodeTableReader {
    protected static final short NO_OPCODE = 256;
    private final VCDiffCodeTableData codeTableData;
    private ByteBuffer instructionsAndSizes;
    private int lastInstructionStart = -1;
    private short pendingSecondInstruction;
    private short lastPendingSecondInstruction;

    public VCDiffCodeTableReader() {
        this.codeTableData = VCDiffCodeTableData.kDefaultCodeTableData;
    }

    public VCDiffCodeTableReader(VCDiffCodeTableData codeTableData, short maxMode) {
        if (!codeTableData.Validate(maxMode)) {
            throw new IllegalArgumentException("Invalid code table data.");
        }
        this.codeTableData = Objects.requireNotNull(codeTableData, "codeTableData was null");
    }

    public void init(ByteBuffer instructions_and_sizes) {
        this.instructionsAndSizes = instructions_and_sizes;
        this.lastInstructionStart = -1;
        this.pendingSecondInstruction = (short)256;
        this.lastPendingSecondInstruction = (short)256;
    }

    public byte getNextInstruction(AtomicInteger size, AtomicInteger mode) throws IOException {
        byte instruction_mode;
        byte instruction_size;
        byte instruction_type;
        if (this.instructionsAndSizes == null) {
            throw new IllegalStateException("Internal error: getNextInstruction() called before init()");
        }
        this.lastInstructionStart = this.instructionsAndSizes.position();
        this.lastPendingSecondInstruction = this.pendingSecondInstruction;
        do {
            byte opcode;
            if (this.pendingSecondInstruction != 256) {
                opcode = (byte)this.pendingSecondInstruction;
                this.pendingSecondInstruction = (short)256;
                instruction_type = this.codeTableData.inst2[opcode & 0xFF];
                instruction_size = this.codeTableData.size2[opcode & 0xFF];
                instruction_mode = this.codeTableData.mode2[opcode & 0xFF];
                break;
            }
            if (!this.instructionsAndSizes.hasRemaining()) {
                return 5;
            }
            opcode = this.instructionsAndSizes.get();
            if (this.codeTableData.inst2[opcode & 0xFF] != 0) {
                this.pendingSecondInstruction = opcode;
            }
            instruction_type = this.codeTableData.inst1[opcode & 0xFF];
            instruction_size = this.codeTableData.size1[opcode & 0xFF];
            instruction_mode = this.codeTableData.mode1[opcode & 0xFF];
        } while (instruction_type == 0);
        if (instruction_size == 0) {
            try {
                size.set(VarInt.getInt(this.instructionsAndSizes));
            }
            catch (VarInt.VarIntParseException e) {
                throw new IOException("Instruction size is not a valid variable-length integer");
            }
            catch (VarInt.VarIntEndOfBufferException e) {
                this.unGetInstruction();
                return 5;
            }
        } else {
            size.set(instruction_size);
        }
        mode.set(instruction_mode);
        return instruction_type;
    }

    public void unGetInstruction() {
        if (this.lastInstructionStart >= 0) {
            if (this.lastInstructionStart > this.instructionsAndSizes.position()) {
                throw new IllegalStateException("Internal error: last_instruction_start past end of instructions_and_sizes in unGetInstruction");
            }
            this.instructionsAndSizes.position(this.lastInstructionStart);
            if (this.pendingSecondInstruction != 256 && this.lastPendingSecondInstruction != 256) {
                throw new IllegalStateException("Internal error: two pending instructions in a row in unGetInstruction");
            }
            this.pendingSecondInstruction = this.lastPendingSecondInstruction;
        }
    }

    void updatePointers(ByteBuffer instructions_and_sizes) {
        this.instructionsAndSizes = instructions_and_sizes;
        this.lastInstructionStart = -1;
        this.lastPendingSecondInstruction = this.pendingSecondInstruction;
    }
}

