/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class CountingInputStream
extends FilterInputStream {
    private final AtomicLong bytesRead = new AtomicLong();

    public CountingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read >= 0) {
            this.bytesRead.getAndIncrement();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.bytesRead.getAndAdd(read);
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.bytesRead.getAndAdd(skipped);
        return skipped;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }
}

