/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.util;

import com.datomic.lucene.store.Directory;
import com.datomic.lucene.store.IndexInput;
import com.datomic.lucene.store.IndexOutput;
import java.io.IOException;

public final class BitVector
implements Cloneable {
    private byte[] bits;
    private int size;
    private int count;
    private static final byte[] BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};

    public BitVector(int n) {
        this.size = n;
        this.bits = new byte[(this.size >> 3) + 1];
        this.count = 0;
    }

    BitVector(byte[] bits, int size) {
        this.bits = bits;
        this.size = size;
        this.count = -1;
    }

    public Object clone() {
        byte[] copyBits = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, copyBits, 0, this.bits.length);
        BitVector clone = new BitVector(copyBits, this.size);
        clone.count = this.count;
        return clone;
    }

    public final void set(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException("bit=" + bit + " size=" + this.size);
        }
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] | 1 << (bit & 7));
        this.count = -1;
    }

    public final boolean getAndSet(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException("bit=" + bit + " size=" + this.size);
        }
        int flag = 1 << (bit & 7);
        int pos = bit >> 3;
        byte v = this.bits[pos];
        if ((flag & v) != 0) {
            return true;
        }
        this.bits[pos] = (byte)(v | flag);
        if (this.count != -1) {
            ++this.count;
        }
        return false;
    }

    public final void clear(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException(bit);
        }
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] & ~(1 << (bit & 7)));
        this.count = -1;
    }

    public final boolean get(int bit) {
        assert (bit >= 0 && bit < this.size) : "bit " + bit + " is out of bounds 0.." + (this.size - 1);
        return (this.bits[bit >> 3] & 1 << (bit & 7)) != 0;
    }

    public final int size() {
        return this.size;
    }

    public final int count() {
        if (this.count == -1) {
            int c = 0;
            int end = this.bits.length;
            for (int i = 0; i < end; ++i) {
                c += BYTE_COUNTS[this.bits[i] & 0xFF];
            }
            this.count = c;
        }
        return this.count;
    }

    public final int getRecomputedCount() {
        int c = 0;
        int end = this.bits.length;
        for (int i = 0; i < end; ++i) {
            c += BYTE_COUNTS[this.bits[i] & 0xFF];
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory d, String name) throws IOException {
        IndexOutput output = d.createOutput(name);
        try {
            if (this.isSparse()) {
                this.writeDgaps(output);
            } else {
                this.writeBits(output);
            }
        }
        finally {
            output.close();
        }
    }

    private void writeBits(IndexOutput output) throws IOException {
        output.writeInt(this.size());
        output.writeInt(this.count());
        output.writeBytes(this.bits, this.bits.length);
    }

    private void writeDgaps(IndexOutput output) throws IOException {
        output.writeInt(-1);
        output.writeInt(this.size());
        output.writeInt(this.count());
        int last = 0;
        int n = this.count();
        int m = this.bits.length;
        for (int i = 0; i < m && n > 0; ++i) {
            if (this.bits[i] == 0) continue;
            output.writeVInt(i - last);
            output.writeByte(this.bits[i]);
            last = i;
            n -= BYTE_COUNTS[this.bits[i] & 0xFF];
        }
    }

    private boolean isSparse() {
        int factor = 10;
        if (this.bits.length < 128) {
            return factor * (4 + 16 * this.count()) < this.size();
        }
        if (this.bits.length < 16384) {
            return factor * (4 + 24 * this.count()) < this.size();
        }
        if (this.bits.length < 0x200000) {
            return factor * (4 + 32 * this.count()) < this.size();
        }
        if (this.bits.length < 0x10000000) {
            return factor * (4 + 40 * this.count()) < this.size();
        }
        return factor * (4 + 48 * this.count()) < this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitVector(Directory d, String name) throws IOException {
        IndexInput input = d.openInput(name);
        try {
            this.size = input.readInt();
            if (this.size == -1) {
                this.readDgaps(input);
            } else {
                this.readBits(input);
            }
        }
        finally {
            input.close();
        }
    }

    private void readBits(IndexInput input) throws IOException {
        this.count = input.readInt();
        this.bits = new byte[(this.size >> 3) + 1];
        input.readBytes(this.bits, 0, this.bits.length);
    }

    private void readDgaps(IndexInput input) throws IOException {
        this.size = input.readInt();
        this.count = input.readInt();
        this.bits = new byte[(this.size >> 3) + 1];
        int last = 0;
        for (int n = this.count(); n > 0; n -= BYTE_COUNTS[this.bits[last] & 0xFF]) {
            this.bits[last += input.readVInt()] = input.readByte();
        }
    }

    public BitVector subset(int start, int end) {
        if (start < 0 || end > this.size() || end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return new BitVector(0);
        }
        byte[] bits = new byte[(end - start - 1 >>> 3) + 1];
        int s = start >>> 3;
        for (int i = 0; i < bits.length; ++i) {
            int cur = 0xFF & this.bits[i + s];
            int next = i + s + 1 >= this.bits.length ? 0 : 0xFF & this.bits[i + s + 1];
            bits[i] = (byte)(cur >>> (start & 7) | next << 8 - (start & 7));
        }
        int bitsToClear = (bits.length * 8 - (end - start)) % 8;
        int n = bits.length - 1;
        bits[n] = (byte)(bits[n] & ~(255 << 8 - bitsToClear));
        return new BitVector(bits, end - start);
    }
}

