/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.search;

import com.datomic.lucene.search.FieldComparator;
import com.datomic.lucene.search.FieldDoc;
import com.datomic.lucene.search.ScoreDoc;
import com.datomic.lucene.search.SortField;
import com.datomic.lucene.util.PriorityQueue;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldValueHitQueue
extends PriorityQueue<Entry> {
    protected final SortField[] fields;
    protected final FieldComparator[] comparators;
    protected final int[] reverseMul;

    private FieldValueHitQueue(SortField[] fields) {
        this.fields = fields;
        int numComparators = fields.length;
        this.comparators = new FieldComparator[numComparators];
        this.reverseMul = new int[numComparators];
    }

    public static FieldValueHitQueue create(SortField[] fields, int size) throws IOException {
        if (fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (fields.length == 1) {
            return new OneComparatorFieldValueHitQueue(fields, size);
        }
        return new MultiComparatorsFieldValueHitQueue(fields, size);
    }

    FieldComparator[] getComparators() {
        return this.comparators;
    }

    int[] getReverseMul() {
        return this.reverseMul;
    }

    @Override
    protected abstract boolean lessThan(Entry var1, Entry var2);

    FieldDoc fillFields(Entry entry) {
        int n = this.comparators.length;
        Object[] fields = new Object[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = this.comparators[i].value(entry.slot);
        }
        return new FieldDoc(entry.doc, entry.score, fields);
    }

    SortField[] getFields() {
        return this.fields;
    }

    private static final class MultiComparatorsFieldValueHitQueue
    extends FieldValueHitQueue {
        public MultiComparatorsFieldValueHitQueue(SortField[] fields, int size) throws IOException {
            super(fields);
            int numComparators = this.comparators.length;
            for (int i = 0; i < numComparators; ++i) {
                SortField field = fields[i];
                this.reverseMul[i] = field.reverse ? -1 : 1;
                this.comparators[i] = field.getComparator(size, i);
            }
            this.initialize(size);
        }

        protected boolean lessThan(Entry hitA, Entry hitB) {
            assert (hitA != hitB);
            assert (hitA.slot != hitB.slot);
            int numComparators = this.comparators.length;
            for (int i = 0; i < numComparators; ++i) {
                int c = this.reverseMul[i] * this.comparators[i].compare(hitA.slot, hitB.slot);
                if (c == 0) continue;
                return c > 0;
            }
            return hitA.doc > hitB.doc;
        }
    }

    private static final class OneComparatorFieldValueHitQueue
    extends FieldValueHitQueue {
        private final FieldComparator comparator;
        private final int oneReverseMul;

        public OneComparatorFieldValueHitQueue(SortField[] fields, int size) throws IOException {
            super(fields);
            SortField field = fields[0];
            this.comparator = field.getComparator(size, 0);
            this.oneReverseMul = field.reverse ? -1 : 1;
            this.comparators[0] = this.comparator;
            this.reverseMul[0] = this.oneReverseMul;
            this.initialize(size);
        }

        protected boolean lessThan(Entry hitA, Entry hitB) {
            assert (hitA != hitB);
            assert (hitA.slot != hitB.slot);
            int c = this.oneReverseMul * this.comparator.compare(hitA.slot, hitB.slot);
            if (c != 0) {
                return c > 0;
            }
            return hitA.doc > hitB.doc;
        }
    }

    static final class Entry
    extends ScoreDoc {
        int slot;

        Entry(int slot, int doc, float score) {
            super(doc, score);
            this.slot = slot;
        }

        public String toString() {
            return "slot:" + this.slot + " " + super.toString();
        }
    }
}

