/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.analysis;

import com.datomic.lucene.analysis.CharArraySet;
import com.datomic.lucene.analysis.ReusableAnalyzerBase;
import com.datomic.lucene.analysis.WordlistLoader;
import com.datomic.lucene.util.Version;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StopwordAnalyzerBase
extends ReusableAnalyzerBase {
    protected final CharArraySet stopwords;
    protected final Version matchVersion;

    public Set<?> getStopwordSet() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase(Version version, Set<?> stopwords) {
        this.matchVersion = version;
        this.stopwords = stopwords == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(version, stopwords));
    }

    protected StopwordAnalyzerBase(Version version) {
        this(version, null);
    }

    protected static CharArraySet loadStopwordSet(boolean ignoreCase, Class<? extends ReusableAnalyzerBase> aClass, String resource, String comment) throws IOException {
        Set<String> wordSet = WordlistLoader.getWordSet(aClass, resource, comment);
        CharArraySet set = new CharArraySet(Version.LUCENE_31, wordSet.size(), ignoreCase);
        set.addAll(wordSet);
        return set;
    }
}

