/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.reporting;

import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.datatheorem.android.trustkit.config.DomainPinningPolicy;
import com.datatheorem.android.trustkit.pinning.PinningValidationResult;
import com.datatheorem.android.trustkit.reporting.BackgroundReporterTask;
import com.datatheorem.android.trustkit.reporting.PinningFailureReport;
import com.datatheorem.android.trustkit.reporting.ReportRateLimiter;
import com.datatheorem.android.trustkit.utils.TrustKitLog;
import java.io.Serializable;
import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BackgroundReporter {
    public static final String REPORT_VALIDATION_EVENT = "com.datatheorem.android.trustkit.reporting.BackgroundReporter:REPORT_VALIDATION_EVENT";
    public static final String EXTRA_REPORT = "Report";
    private final String appPackageName;
    private final String appVersion;
    private final String appVendorId;
    private final Context context;

    public BackgroundReporter(@NonNull Context context, @NonNull String appPackageName, @NonNull String appVersion, @NonNull String appVendorId) {
        this.context = context;
        this.appPackageName = appPackageName;
        this.appVersion = appVersion;
        this.appVendorId = appVendorId;
    }

    private static String certificateToPem(X509Certificate certificate) {
        byte[] certificateData;
        try {
            certificateData = certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("Should never happen - certificate was previously parsed by the system");
        }
        String certificateAsPem = "-----BEGIN CERTIFICATE-----\n";
        certificateAsPem = certificateAsPem + Base64.encodeToString((byte[])certificateData, (int)0);
        certificateAsPem = certificateAsPem + "-----END CERTIFICATE-----\n";
        return certificateAsPem;
    }

    @RequiresApi(api=16)
    public void pinValidationFailed(@NonNull String serverHostname, @NonNull Integer serverPort, @NonNull List<X509Certificate> servedCertificateChain, @NonNull List<X509Certificate> validatedCertificateChain, @NonNull DomainPinningPolicy serverConfig, @NonNull PinningValidationResult validationResult) {
        TrustKitLog.i("Generating pin failure report for " + serverHostname);
        ArrayList<String> validatedCertificateChainAsPem = new ArrayList<String>();
        for (X509Certificate x509Certificate : validatedCertificateChain) {
            validatedCertificateChainAsPem.add(BackgroundReporter.certificateToPem(x509Certificate));
        }
        ArrayList<String> servedCertificateChainAsPem = new ArrayList<String>();
        for (X509Certificate certificate : servedCertificateChain) {
            servedCertificateChainAsPem.add(BackgroundReporter.certificateToPem(certificate));
        }
        PinningFailureReport pinningFailureReport = new PinningFailureReport(this.appPackageName, this.appVersion, this.appVendorId, serverHostname, serverPort, serverConfig.getHostname(), serverConfig.shouldIncludeSubdomains(), serverConfig.shouldEnforcePinning(), servedCertificateChainAsPem, validatedCertificateChainAsPem, new Date(System.currentTimeMillis()), serverConfig.getPublicKeyPins(), validationResult);
        if (!ReportRateLimiter.shouldRateLimit(pinningFailureReport)) {
            this.sendReport(pinningFailureReport, serverConfig.getReportUris());
            this.broadcastReport(pinningFailureReport);
        } else {
            TrustKitLog.i("Report for " + serverHostname + " was not sent due to rate-limiting");
        }
    }

    @RequiresApi(api=16)
    protected void sendReport(@NonNull PinningFailureReport report, @NonNull Set<URL> reportUriSet) {
        ArrayList<Serializable> taskParameters = new ArrayList<Serializable>();
        taskParameters.add(report);
        taskParameters.addAll(reportUriSet);
        new BackgroundReporterTask().execute(taskParameters.toArray());
    }

    protected void broadcastReport(@NonNull PinningFailureReport report) {
        Intent intent = new Intent(REPORT_VALIDATION_EVENT);
        intent.putExtra(EXTRA_REPORT, (Serializable)report);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }
}

