/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Printer;
import androidx.annotation.NonNull;
import com.datatheorem.android.trustkit.config.ConfigurationException;
import com.datatheorem.android.trustkit.config.TrustKitConfiguration;
import com.datatheorem.android.trustkit.pinning.TrustManagerBuilder;
import com.datatheorem.android.trustkit.reporting.BackgroundReporter;
import com.datatheorem.android.trustkit.utils.TrustKitLog;
import com.datatheorem.android.trustkit.utils.VendorIdentifier;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TrustKit {
    protected static TrustKit trustKitInstance;
    private final TrustKitConfiguration trustKitConfiguration;

    protected TrustKit(@NonNull Context context, @NonNull TrustKitConfiguration trustKitConfiguration) {
        String appVersion;
        this.trustKitConfiguration = trustKitConfiguration;
        boolean isAppDebuggable = 0 != (context.getApplicationInfo().flags & 2);
        Set<Certificate> debugCaCerts = null;
        boolean shouldOverridePins = false;
        if (isAppDebuggable) {
            debugCaCerts = trustKitConfiguration.getDebugCaCertificates();
            if (debugCaCerts != null) {
                TrustKitLog.i("App is debuggable - processing <debug-overrides> configuration.");
            }
            shouldOverridePins = trustKitConfiguration.shouldOverridePins();
        }
        String appPackageName = context.getPackageName();
        try {
            appVersion = context.getPackageManager().getPackageInfo((String)appPackageName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            appVersion = "N/A";
        }
        if (appVersion == null) {
            appVersion = "N/A";
        }
        String appVendorId = VendorIdentifier.getOrCreate(context);
        BackgroundReporter reporter = new BackgroundReporter(context, appPackageName, appVersion, appVendorId);
        try {
            TrustManagerBuilder.initializeBaselineTrustManager(debugCaCerts, shouldOverridePins, reporter);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ConfigurationException("Could not parse <debug-overrides> certificates");
        }
    }

    private static int getNetSecConfigResourceId(@NonNull Context context) {
        ApplicationInfo info = context.getApplicationInfo();
        class NetSecConfigResIdRetriever
        implements Printer {
            private int netSecConfigResourceId = -1;
            private final String NETSEC_LINE_FORMAT = "networkSecurityConfigRes=0x";

            NetSecConfigResIdRetriever() {
            }

            public void println(String x) {
                if (this.netSecConfigResourceId == -1 && x.contains("networkSecurityConfigRes=0x")) {
                    this.netSecConfigResourceId = Integer.parseInt(x.substring("networkSecurityConfigRes=0x".length()), 16);
                }
            }

            private int getNetworkSecurityConfigResId() {
                return this.netSecConfigResourceId;
            }
        }
        NetSecConfigResIdRetriever retriever = new NetSecConfigResIdRetriever();
        info.dump((Printer)retriever, "");
        return retriever.getNetworkSecurityConfigResId();
    }

    @NonNull
    public static synchronized TrustKit initializeWithNetworkSecurityConfiguration(@NonNull Context context) {
        int networkSecurityConfigId = context.getResources().getIdentifier("network_security_config", "xml", context.getPackageName());
        return TrustKit.initializeWithNetworkSecurityConfiguration(context, networkSecurityConfigId);
    }

    @NonNull
    public static synchronized TrustKit initializeWithNetworkSecurityConfiguration(@NonNull Context context, int configurationResourceId) {
        TrustKitConfiguration trustKitConfiguration;
        if (trustKitInstance != null) {
            throw new IllegalStateException("TrustKit has already been initialized");
        }
        if (Build.VERSION.SDK_INT >= 24) {
            int systemConfigResId = TrustKit.getNetSecConfigResourceId(context);
            if (systemConfigResId == -1) {
                throw new ConfigurationException("TrustKit was initialized with a network policy that was not properly configured for Android N - make sure it is in the App's Manifest.");
            }
            if (systemConfigResId != configurationResourceId) {
                throw new ConfigurationException("TrustKit was initialized with a different network policy than the one configured in the App's manifest.");
            }
        }
        try {
            trustKitConfiguration = TrustKitConfiguration.fromXmlPolicy(context, (XmlPullParser)context.getResources().getXml(configurationResourceId));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ConfigurationException("Could not parse network security policy file");
        }
        catch (CertificateException e) {
            throw new ConfigurationException("Could not find the debug certificate in the network security police file");
        }
        trustKitInstance = new TrustKit(context, trustKitConfiguration);
        return trustKitInstance;
    }

    @NonNull
    public static TrustKit getInstance() {
        if (trustKitInstance == null) {
            throw new IllegalStateException("TrustKit has not been initialized");
        }
        return trustKitInstance;
    }

    @NonNull
    public TrustKitConfiguration getConfiguration() {
        return this.trustKitConfiguration;
    }

    @NonNull
    public SSLSocketFactory getSSLSocketFactory(@NonNull String serverHostname) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.getTrustManager(serverHostname)}, null);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException("Should not happen");
        }
    }

    @NonNull
    public X509TrustManager getTrustManager(@NonNull String serverHostname) {
        return TrustManagerBuilder.getTrustManager(serverHostname);
    }
}

