/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class TimeUtils {
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final long MAX_CQL_LONG_VALUE = 0xFFFFFFFFL;
    private static final long EPOCH_AS_CQL_LONG = 0x80000000L;

    private TimeUtils() {
    }

    public static String formatLocalDate(LocalDate value) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(value);
    }

    public static LocalDate parseLocaDate(String value) {
        try {
            return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Couldn't parse literal, expected ISO-8601 extended local date format (YYYY-MM-DD)");
        }
    }

    public static LocalDate parseLocaDate(long value) {
        int days = TimeUtils.cqlDateToDaysSinceEpoch(value);
        return EPOCH.plusDays(days);
    }

    private static int cqlDateToDaysSinceEpoch(long raw) {
        if (raw < 0L || raw > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Numeric Date literals must be between 0 and %d (got %d)", 0xFFFFFFFFL, raw));
        }
        return (int)(raw - 0x80000000L);
    }
}

