/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class ByteBufCodec
implements PrimitiveCodec<ByteBuf> {
    private final ByteBufAllocator alloc;

    ByteBufCodec() {
        this(ByteBufAllocator.DEFAULT);
    }

    ByteBufCodec(ByteBufAllocator alloc) {
        this.alloc = alloc;
    }

    public ByteBuf allocate(int size) {
        return this.alloc.buffer(size);
    }

    public void release(ByteBuf toRelease) {
        toRelease.release();
    }

    public int sizeOf(ByteBuf toMeasure) {
        return toMeasure.readableBytes();
    }

    public ByteBuf concat(ByteBuf left, ByteBuf right) {
        return new CompositeByteBuf(this.alloc, this.alloc.isDirectBufferPooled(), 2, new ByteBuf[]{left, right});
    }

    public byte readByte(ByteBuf source) {
        return source.readByte();
    }

    public int readInt(ByteBuf source) {
        return source.readInt();
    }

    public InetAddress readInetAddr(ByteBuf source) {
        byte len = this.readByte(source);
        byte[] addr = new byte[len];
        source.readBytes(addr);
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe);
        }
    }

    public long readLong(ByteBuf source) {
        return source.readLong();
    }

    public int readUnsignedShort(ByteBuf source) {
        return source.readUnsignedShort();
    }

    public ByteBuffer readBytes(ByteBuf source) {
        int length = this.readInt(source);
        if (length < 0) {
            return null;
        }
        ByteBuf slice = source.readSlice(length);
        return ByteBuffer.wrap(ByteBufCodec.readRawBytes(slice));
    }

    private static byte[] readRawBytes(ByteBuf buffer) {
        if (buffer.hasArray() && buffer.readableBytes() == buffer.array().length) {
            buffer.readerIndex(buffer.writerIndex());
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    public byte[] readShortBytes(ByteBuf source) {
        int len = this.readUnsignedShort(source);
        byte[] out = new byte[len];
        source.readBytes(out);
        return out;
    }

    public String readString(ByteBuf source) {
        int len = this.readUnsignedShort(source);
        String str = source.toString(source.readerIndex(), len, CharsetUtil.UTF_8);
        source.readerIndex(source.readerIndex() + len);
        return str;
    }

    public String readLongString(ByteBuf source) {
        int len = this.readInt(source);
        String str = source.toString(source.readerIndex(), len, CharsetUtil.UTF_8);
        source.readerIndex(source.readerIndex() + len);
        return str;
    }

    public void writeByte(byte b, ByteBuf dest) {
        dest.writeByte((int)b);
    }

    public void writeInt(int i, ByteBuf dest) {
        dest.writeInt(i);
    }

    public void writeInetAddr(InetAddress address, ByteBuf dest) {
        byte[] addr = address.getAddress();
        dest.writeByte(addr.length);
        dest.writeBytes(addr);
    }

    public void writeLong(long l, ByteBuf dest) {
        dest.writeLong(l);
    }

    public void writeUnsignedShort(int i, ByteBuf dest) {
        dest.writeShort(i);
    }

    public void writeString(String s, ByteBuf dest) {
        byte[] data = s.getBytes(CharsetUtil.UTF_8);
        this.writeUnsignedShort(data.length, dest);
        dest.writeBytes(data);
    }

    public void writeLongString(String s, ByteBuf dest) {
        byte[] data = s.getBytes(CharsetUtil.UTF_8);
        this.writeInt(data.length, dest);
        dest.writeBytes(data);
    }

    public void writeBytes(ByteBuffer bytes, ByteBuf dest) {
        if (bytes == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes.remaining(), dest);
            dest.writeBytes(bytes.duplicate());
        }
    }

    public void writeBytes(byte[] bytes, ByteBuf dest) {
        if (bytes == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes.length, dest);
            dest.writeBytes(bytes);
        }
    }

    public void writeShortBytes(byte[] bytes, ByteBuf dest) {
        if (bytes == null) {
            this.writeUnsignedShort(-1, dest);
        } else {
            this.writeUnsignedShort(bytes.length, dest);
            dest.writeBytes(bytes);
        }
    }
}

