/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.cluster.AbstractCluster;
import com.datastax.oss.simulacron.common.cluster.AbstractDataCenter;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.ClusterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.ClusterQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.DataCenterSpec;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.common.stubbing.CloseType;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import com.datastax.oss.simulacron.server.BoundCluster;
import com.datastax.oss.simulacron.server.BoundNode;
import com.datastax.oss.simulacron.server.BoundTopic;
import com.datastax.oss.simulacron.server.FrameCodecUtils;
import com.datastax.oss.simulacron.server.FrameCodecWrapper;
import com.datastax.oss.simulacron.server.QueryListenerWrapper;
import com.datastax.oss.simulacron.server.Server;
import com.datastax.oss.simulacron.server.StubStore;
import com.datastax.oss.simulacron.server.listener.QueryListener;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BoundDataCenter
extends AbstractDataCenter<BoundCluster, BoundNode>
implements BoundTopic<DataCenterConnectionReport, DataCenterQueryLogReport> {
    private final transient Server server;
    private final transient BoundCluster cluster;
    private final transient StubStore stubStore;
    private final transient List<QueryListenerWrapper> queryListeners = new ArrayList<QueryListenerWrapper>();
    private final transient FrameCodecWrapper frameCodec;

    BoundDataCenter(BoundCluster parent) {
        super("dummy", Long.valueOf(0L), parent.getCassandraVersion(), parent.getDSEVersion(), parent.getPeerInfo(), (AbstractCluster)parent);
        this.server = parent.getServer();
        this.cluster = parent;
        this.stubStore = new StubStore();
        this.frameCodec = parent.getFrameCodec();
    }

    BoundDataCenter(DataCenterSpec delegate, BoundCluster parent) {
        super(delegate.getName(), delegate.getId(), delegate.getCassandraVersion(), delegate.getDSEVersion(), delegate.getPeerInfo(), (AbstractCluster)parent);
        this.server = parent.getServer();
        this.cluster = parent;
        this.stubStore = new StubStore();
        this.frameCodec = FrameCodecUtils.buildFrameCodec((NodeProperties)delegate).orElse(parent.getFrameCodec());
    }

    @Override
    public StubStore getStubStore() {
        return this.stubStore;
    }

    @Override
    public int clearPrimes(boolean nested) {
        int cleared = this.getStubStore().clear();
        if (nested) {
            for (BoundNode node : this.getNodes()) {
                cleared += node.clearPrimes(true);
            }
        }
        return cleared;
    }

    @Override
    public CompletionStage<BoundCluster> unregisterAsync() {
        return this.getServer().unregisterAsync((BoundCluster)this.getCluster());
    }

    @Override
    public DataCenterConnectionReport getConnections() {
        ClusterConnectionReport clusterConnectionReport = new ClusterConnectionReport(this.cluster.getId());
        for (BoundNode node : this.getNodes()) {
            clusterConnectionReport.addNode((AbstractNode)node, node.clientChannelGroup.stream().map(Channel::remoteAddress).collect(Collectors.toList()), node.getAddress());
        }
        return (DataCenterConnectionReport)clusterConnectionReport.getDataCenters().iterator().next();
    }

    @Override
    public CompletionStage<DataCenterConnectionReport> closeConnectionsAsync(CloseType closeType) {
        DataCenterConnectionReport report = this.getConnections();
        return CompletableFuture.allOf(this.getNodes().stream().map(n -> n.closeConnectionsAsync(closeType).toCompletableFuture()).collect(Collectors.toList()).toArray(new CompletableFuture[0])).thenApply(v -> report);
    }

    @Override
    public CompletionStage<DataCenterConnectionReport> closeConnectionAsync(SocketAddress connection, CloseType type) {
        for (BoundNode node : this.getNodes()) {
            for (SocketAddress address : node.getConnections().getConnections()) {
                if (!connection.equals(address)) continue;
                return node.closeConnectionAsync(address, type).thenApply(n -> (DataCenterConnectionReport)n.getRootReport().getDataCenters().iterator().next());
            }
        }
        CompletableFuture<DataCenterConnectionReport> failedFuture = new CompletableFuture<DataCenterConnectionReport>();
        failedFuture.completeExceptionally(new IllegalArgumentException("Not found"));
        return failedFuture;
    }

    @Override
    @JsonIgnore
    public DataCenterQueryLogReport getLogs(boolean primed) {
        ClusterQueryLogReport clusterQueryLogReport = new ClusterQueryLogReport(this.cluster.getId());
        this.getNodes().forEach(n -> clusterQueryLogReport.addNode((AbstractNode)n, n.activityLog.getLogs(primed)));
        return (DataCenterQueryLogReport)clusterQueryLogReport.getDataCenters().iterator().next();
    }

    @Override
    public void registerQueryListener(QueryListener queryListener, boolean after, Predicate<QueryLog> filter) {
        this.queryListeners.add(new QueryListenerWrapper(queryListener, after, filter));
    }

    @Override
    @JsonIgnore
    public DataCenterQueryLogReport getLogs() {
        ClusterQueryLogReport clusterQueryLogReport = new ClusterQueryLogReport(this.cluster.getId());
        this.getNodes().forEach(n -> clusterQueryLogReport.addNode((AbstractNode)n, n.activityLog.getLogs()));
        return (DataCenterQueryLogReport)clusterQueryLogReport.getDataCenters().iterator().next();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    @JsonIgnore
    public FrameCodecWrapper getFrameCodec() {
        return this.frameCodec;
    }

    Optional<StubMapping> find(BoundNode node, Frame frame) {
        Optional<StubMapping> stub = this.stubStore.find(node, frame);
        if (!stub.isPresent()) {
            stub = ((BoundCluster)this.getCluster()).find(node, frame);
        }
        return stub;
    }

    void notifyQueryListeners(BoundNode node, QueryLog queryLog, boolean after) {
        if (queryLog != null && !this.queryListeners.isEmpty()) {
            for (QueryListenerWrapper wrapper : this.queryListeners) {
                if (after != wrapper.after) continue;
                wrapper.apply(node, queryLog);
            }
        }
        ((BoundCluster)this.getCluster()).notifyQueryListeners(node, queryLog, after);
    }
}

