/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.cluster.AbstractCluster;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.ClusterConnectionReport;
import com.datastax.oss.simulacron.common.cluster.ClusterQueryLogReport;
import com.datastax.oss.simulacron.common.cluster.ClusterSpec;
import com.datastax.oss.simulacron.common.cluster.NodeConnectionReport;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.common.stubbing.CloseType;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import com.datastax.oss.simulacron.server.BoundDataCenter;
import com.datastax.oss.simulacron.server.BoundNode;
import com.datastax.oss.simulacron.server.BoundTopic;
import com.datastax.oss.simulacron.server.FrameCodecUtils;
import com.datastax.oss.simulacron.server.FrameCodecWrapper;
import com.datastax.oss.simulacron.server.QueryListenerWrapper;
import com.datastax.oss.simulacron.server.Server;
import com.datastax.oss.simulacron.server.StubStore;
import com.datastax.oss.simulacron.server.listener.QueryListener;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BoundCluster
extends AbstractCluster<BoundDataCenter, BoundNode>
implements BoundTopic<ClusterConnectionReport, ClusterQueryLogReport> {
    private final transient Server server;
    private final transient StubStore stubStore;
    private final transient List<QueryListenerWrapper> queryListeners = new ArrayList<QueryListenerWrapper>();
    private final transient FrameCodecWrapper frameCodec;

    BoundCluster(ClusterSpec delegate, Long clusterId, Server server) {
        super(delegate.getName(), clusterId, delegate.getCassandraVersion(), delegate.getDSEVersion(), delegate.getPeerInfo());
        this.server = server;
        this.stubStore = new StubStore();
        this.frameCodec = FrameCodecUtils.buildFrameCodec((NodeProperties)delegate).orElse(FrameCodecUtils.defaultFrameCodec());
    }

    @Override
    public StubStore getStubStore() {
        return this.stubStore;
    }

    @Override
    public int clearPrimes(boolean nested) {
        int cleared = this.getStubStore().clear();
        if (nested) {
            for (BoundDataCenter dc : this.getDataCenters()) {
                cleared += dc.clearPrimes(true);
            }
        }
        return cleared;
    }

    @Override
    public CompletionStage<BoundCluster> unregisterAsync() {
        return this.getServer().unregisterAsync(this);
    }

    @Override
    public ClusterConnectionReport getConnections() {
        ClusterConnectionReport clusterConnectionReport = new ClusterConnectionReport(this.getId());
        for (BoundNode node : this.getNodes()) {
            clusterConnectionReport.addNode((AbstractNode)node, node.clientChannelGroup.stream().map(Channel::remoteAddress).collect(Collectors.toList()), node.getAddress());
        }
        return clusterConnectionReport;
    }

    @Override
    public CompletionStage<ClusterConnectionReport> closeConnectionsAsync(CloseType closeType) {
        ClusterConnectionReport report = this.getConnections();
        return CompletableFuture.allOf(this.getNodes().stream().map(n -> n.closeConnectionsAsync(closeType).toCompletableFuture()).collect(Collectors.toList()).toArray(new CompletableFuture[0])).thenApply(v -> report);
    }

    @Override
    public CompletionStage<ClusterConnectionReport> closeConnectionAsync(SocketAddress connection, CloseType type) {
        for (BoundNode node : this.getNodes()) {
            for (SocketAddress address : node.getConnections().getConnections()) {
                if (!connection.equals(address)) continue;
                return node.closeConnectionAsync(address, type).thenApply(NodeConnectionReport::getRootReport);
            }
        }
        CompletableFuture<ClusterConnectionReport> failedFuture = new CompletableFuture<ClusterConnectionReport>();
        failedFuture.completeExceptionally(new IllegalArgumentException("Not found"));
        return failedFuture;
    }

    @Override
    @JsonIgnore
    public ClusterQueryLogReport getLogs() {
        ClusterQueryLogReport clusterQueryLogReport = new ClusterQueryLogReport(this.getId());
        this.getNodes().forEach(n -> clusterQueryLogReport.addNode((AbstractNode)n, n.activityLog.getLogs()));
        return clusterQueryLogReport;
    }

    @Override
    @JsonIgnore
    public ClusterQueryLogReport getLogs(boolean primed) {
        ClusterQueryLogReport clusterQueryLogReport = new ClusterQueryLogReport(this.getId());
        this.getNodes().forEach(n -> clusterQueryLogReport.addNode((AbstractNode)n, n.activityLog.getLogs(primed)));
        return clusterQueryLogReport;
    }

    @Override
    public void registerQueryListener(QueryListener queryListener, boolean after, Predicate<QueryLog> filter) {
        this.queryListeners.add(new QueryListenerWrapper(queryListener, after, filter));
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    @JsonIgnore
    public FrameCodecWrapper getFrameCodec() {
        return this.frameCodec;
    }

    Optional<StubMapping> find(BoundNode node, Frame frame) {
        Optional<StubMapping> stub = this.stubStore.find(node, frame);
        if (!stub.isPresent() && this.server != null) {
            stub = this.server.stubStore.find(node, frame);
        }
        return stub;
    }

    void notifyQueryListeners(BoundNode node, QueryLog queryLog, boolean after) {
        if (queryLog != null && !this.queryListeners.isEmpty()) {
            for (QueryListenerWrapper wrapper : this.queryListeners) {
                if (after != wrapper.after) continue;
                wrapper.apply(node, queryLog);
            }
        }
    }
}

