/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.protocol.json;

import com.datastax.oss.protocol.internal.request.Batch;
import com.datastax.oss.simulacron.protocol.json.MessageSerializer;
import com.datastax.oss.simulacron.protocol.json.SerializerUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class BatchSerializer
extends MessageSerializer<Batch> {
    @Override
    public void serializeMessage(Batch batch, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String batchType;
        switch (batch.type) {
            case 0: {
                batchType = "LOGGED";
                break;
            }
            case 1: {
                batchType = "UNLOGGED";
                break;
            }
            case 2: {
                batchType = "COUNTER";
                break;
            }
            default: {
                batchType = "" + batch.type;
            }
        }
        jsonGenerator.writeObjectField("type", (Object)batchType);
        jsonGenerator.writeObjectField("queries_or_ids", (Object)batch.queriesOrIds);
        jsonGenerator.writeObjectField("values", (Object)batch.values);
        jsonGenerator.writeObjectField("consistency", (Object)SerializerUtils.toConsistencyString(batch.consistency));
        jsonGenerator.writeObjectField("serial_consistency", (Object)SerializerUtils.toConsistencyString(batch.serialConsistency));
        jsonGenerator.writeObjectField("default_timestamp", (Object)batch.defaultTimestamp);
        jsonGenerator.writeObjectField("keyspace", (Object)batch.keyspace);
    }
}

