/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.stubbing;

import com.datastax.oss.simulacron.common.cluster.RequestPrime;
import com.datastax.oss.simulacron.common.codec.ConsistencyLevel;
import com.datastax.oss.simulacron.common.codec.RequestFailureReason;
import com.datastax.oss.simulacron.common.codec.WriteType;
import com.datastax.oss.simulacron.common.request.Options;
import com.datastax.oss.simulacron.common.request.Query;
import com.datastax.oss.simulacron.common.request.Request;
import com.datastax.oss.simulacron.common.result.AlreadyExistsResult;
import com.datastax.oss.simulacron.common.result.AuthenticationErrorResult;
import com.datastax.oss.simulacron.common.result.CloseConnectionResult;
import com.datastax.oss.simulacron.common.result.ConfigurationErrorResult;
import com.datastax.oss.simulacron.common.result.FunctionFailureResult;
import com.datastax.oss.simulacron.common.result.InvalidResult;
import com.datastax.oss.simulacron.common.result.IsBootstrappingResult;
import com.datastax.oss.simulacron.common.result.NoResult;
import com.datastax.oss.simulacron.common.result.OverloadedResult;
import com.datastax.oss.simulacron.common.result.ProtocolErrorResult;
import com.datastax.oss.simulacron.common.result.ReadFailureResult;
import com.datastax.oss.simulacron.common.result.ReadTimeoutResult;
import com.datastax.oss.simulacron.common.result.Result;
import com.datastax.oss.simulacron.common.result.ServerErrorResult;
import com.datastax.oss.simulacron.common.result.SuccessResult;
import com.datastax.oss.simulacron.common.result.SyntaxErrorResult;
import com.datastax.oss.simulacron.common.result.TruncateErrorResult;
import com.datastax.oss.simulacron.common.result.UnauthorizedResult;
import com.datastax.oss.simulacron.common.result.UnavailableResult;
import com.datastax.oss.simulacron.common.result.UnpreparedResult;
import com.datastax.oss.simulacron.common.result.VoidResult;
import com.datastax.oss.simulacron.common.result.WriteFailureResult;
import com.datastax.oss.simulacron.common.result.WriteTimeoutResult;
import com.datastax.oss.simulacron.common.stubbing.CloseType;
import com.datastax.oss.simulacron.common.stubbing.DisconnectAction;
import com.datastax.oss.simulacron.common.stubbing.Prime;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PrimeDsl {
    public static Options options = Options.INSTANCE;
    private static final Map<String, String> noRowsColumnTypes = new HashMap<String, String>();
    private static final List<Map<String, Object>> emptyRows;

    public static PrimeBuilder when(Request when) {
        return new PrimeBuilder(when);
    }

    public static PrimeBuilder when(String query) {
        return PrimeDsl.when(new Query(query));
    }

    public static Query query(String query, List<ConsistencyLevel> consistencies, Map<String, Object> params, Map<String, String> paramTypes) {
        return new Query(query, consistencies, params, paramTypes);
    }

    public static Query query(String query, List<ConsistencyLevel> consistencies) {
        return PrimeDsl.query(query, consistencies, null, null);
    }

    public static Query query(String query, ConsistencyLevel consistency) {
        return PrimeDsl.query(query, Collections.singletonList(consistency));
    }

    public static SuccessResult noRows() {
        return new SuccessResult(emptyRows, noRowsColumnTypes);
    }

    public static SuccessResult rows(List<Map<String, Object>> rows, Map<String, String> columnTypes) {
        return new SuccessResult(rows, columnTypes);
    }

    public static RowBuilder rows() {
        return new RowBuilder();
    }

    public static AlreadyExistsResult alreadyExists(String keyspace) {
        return new AlreadyExistsResult("unused", keyspace);
    }

    public static AlreadyExistsResult alreadyExists(String keyspace, String table) {
        return new AlreadyExistsResult("unused", keyspace, table);
    }

    public static AuthenticationErrorResult authenticationError(String message) {
        return new AuthenticationErrorResult(message);
    }

    public static ConfigurationErrorResult configurationError(String message) {
        return new ConfigurationErrorResult(message);
    }

    public static CloseConnectionResult closeConnection(DisconnectAction.Scope scope, CloseType closeType) {
        return new CloseConnectionResult(scope, closeType);
    }

    public static FunctionFailureResult functionFailure(String keyspace, String function, List<String> argTypes, String detail) {
        return new FunctionFailureResult(keyspace, function, argTypes, detail);
    }

    public static InvalidResult invalid(String message) {
        return new InvalidResult(message);
    }

    public static IsBootstrappingResult isBootstrapping() {
        return new IsBootstrappingResult();
    }

    public static OverloadedResult overloaded(String message) {
        return new OverloadedResult(message);
    }

    public static ProtocolErrorResult protocolError(String message) {
        return new ProtocolErrorResult(message);
    }

    public static VoidResult void_() {
        return new VoidResult();
    }

    public static NoResult noResult() {
        return new NoResult();
    }

    public static ReadFailureResult readFailure(ConsistencyLevel cl, int received, int blockFor, Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, boolean dataPresent) {
        return new ReadFailureResult(cl, received, blockFor, failureReasonByEndpoint, dataPresent);
    }

    public static ReadTimeoutResult readTimeout(ConsistencyLevel cl, int received, int blockFor, boolean dataPresent) {
        return new ReadTimeoutResult(cl, received, blockFor, dataPresent);
    }

    public static ServerErrorResult serverError(String message) {
        return new ServerErrorResult(message);
    }

    public static SyntaxErrorResult syntaxError(String message) {
        return new SyntaxErrorResult(message);
    }

    public static TruncateErrorResult truncateError(String message) {
        return new TruncateErrorResult(message);
    }

    public static UnauthorizedResult unauthorized(String message) {
        return new UnauthorizedResult(message);
    }

    public static UnavailableResult unavailable(ConsistencyLevel cl, int required, int alive) {
        return new UnavailableResult(cl, required, alive);
    }

    public static UnpreparedResult unprepared(String message) {
        return new UnpreparedResult(message);
    }

    public static WriteFailureResult writeFailure(ConsistencyLevel cl, int received, int blockFor, Map<InetAddress, RequestFailureReason> failureReasonByEndpoint, WriteType writeType) {
        return new WriteFailureResult(cl, received, blockFor, failureReasonByEndpoint, writeType);
    }

    public static WriteTimeoutResult writeTimeout(ConsistencyLevel cl, int received, int blockFor, WriteType writeType) {
        return new WriteTimeoutResult(cl, received, blockFor, writeType);
    }

    static {
        noRowsColumnTypes.put("fake", "varchar");
        emptyRows = new ArrayList<Map<String, Object>>();
    }

    public static class RowBuilder {
        List<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        Map<String, String> columnTypes;

        public RowBuilder row(Object ... data) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            if (data.length % 2 != 0) {
                throw new RuntimeException("Expected row data to contain an even number of values, but was given " + data.length);
            }
            for (int i = 0; i < data.length - 1; i += 2) {
                rowData.put(data[i].toString(), data[i + 1]);
            }
            this.rows.add(rowData);
            return this;
        }

        public RowBuilder columnTypes(String ... columns) {
            if (columns.length % 2 != 0) {
                throw new RuntimeException("Expected row data to contain an even number of values, but was given " + columns.length);
            }
            this.columnTypes = new HashMap<String, String>();
            for (int i = 0; i < columns.length - 1; i += 2) {
                this.columnTypes.put(columns[i], columns[i + 1]);
            }
            return this;
        }

        public SuccessResult build() {
            if (this.columnTypes == null) {
                this.columnTypes = Collections.emptyMap();
            }
            return new SuccessResult(this.rows, this.columnTypes);
        }
    }

    public static class PrimeBuilder {
        private Request when;
        private Result then;

        PrimeBuilder(Request when) {
            this.when = when;
        }

        public PrimeBuilder then(Result then) {
            this.then = then;
            return this;
        }

        public PrimeBuilder then(RowBuilder rowBuilder) {
            this.then = rowBuilder.build();
            return this;
        }

        public PrimeBuilder delay(long delay, TimeUnit delayUnit) {
            if (this.then == null) {
                throw new RuntimeException("then must be called before delay.");
            }
            this.then.setDelay(delay, delayUnit);
            return this;
        }

        public PrimeBuilder ignoreOnPrepare() {
            if (this.then == null) {
                throw new RuntimeException("then must be called before ignoreOnPrepare.");
            }
            this.then.setIgnoreOnPrepare(true);
            return this;
        }

        public PrimeBuilder applyToPrepare() {
            if (this.then == null) {
                throw new RuntimeException("then must be called before applyToPrepare.");
            }
            this.then.setIgnoreOnPrepare(false);
            return this;
        }

        public Prime build() {
            return new Prime(new RequestPrime(this.when, this.then));
        }
    }
}

