/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.request;

import com.datastax.oss.simulacron.common.codec.CqlMapper;
import com.datastax.oss.simulacron.common.request.Request;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Statement {
    public final String query;
    public final Map<String, String> paramTypes;
    public final Map<String, Object> params;

    @JsonCreator
    public Statement(@JsonProperty(value="query") String query, @JsonProperty(value="param_types") Map<String, String> paramTypes, @JsonProperty(value="params") Map<String, Object> params) {
        this.query = query;
        this.paramTypes = paramTypes;
        this.params = params;
    }

    public boolean checkStatementMatch(int protocolVersion, Object queryOrId, List<ByteBuffer> positionalValues) {
        if (queryOrId instanceof String) {
            if (this.params == null || this.params.size() == 0) {
                return true;
            }
            if (!this.query.equals(queryOrId)) {
                return false;
            }
            if (positionalValues.size() != this.params.size()) {
                return false;
            }
            Iterator<Object> primedPositionValues = this.params.values().iterator();
            Iterator<String> primedPositionTypes = this.paramTypes.values().iterator();
            CqlMapper mapper = CqlMapper.forVersion(protocolVersion);
            for (ByteBuffer buffer : positionalValues) {
                if (Request.checkParamsEqual(buffer, primedPositionValues.next(), primedPositionTypes.next(), mapper)) continue;
                return false;
            }
            return true;
        }
        Integer queryIdInt = new BigInteger((byte[])queryOrId).intValue();
        if (queryIdInt.equals(this.getQueryId())) {
            CqlMapper mapper = CqlMapper.forVersion(protocolVersion);
            Iterator<Object> primedPositionValues = this.params.values().iterator();
            Iterator<String> primedPositionTypes = this.paramTypes.values().iterator();
            Iterator<ByteBuffer> iterator = positionalValues.iterator();
            if (iterator.hasNext()) {
                ByteBuffer buffer = iterator.next();
                return Request.checkParamsEqual(buffer, primedPositionValues.next(), primedPositionTypes.next(), mapper);
            }
            return true;
        }
        return false;
    }

    @JsonIgnore
    public int getQueryId() {
        return this.query.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        if (!this.query.equals(statement.query)) {
            return false;
        }
        if (!this.paramTypes.equals(statement.paramTypes)) {
            return false;
        }
        return this.params.equals(statement.params);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + this.paramTypes.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }
}

