/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.Identifiable;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public interface NodeProperties
extends Identifiable {
    default public <T> T resolve(Function<NodeProperties, T> methodRef, T defaultValue) {
        return (T)Optional.ofNullable(methodRef.apply(this)).orElseGet(() -> this.getParent().map(p -> p.resolve(methodRef, defaultValue)).orElse(defaultValue));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public UUID getHostId();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCassandraVersion();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDSEVersion();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getPeerInfo();

    public Long getActiveConnections();

    public Optional<NodeProperties> getParent();

    default public String resolveCassandraVersion() {
        return this.resolve(NodeProperties::getCassandraVersion, "3.0.12");
    }

    default public String resolveDSEVersion() {
        return this.resolve(NodeProperties::getDSEVersion, null);
    }

    default public String resolveName() {
        return this.getParent().map(p -> p.resolveName() + ":").orElse("") + this.getName();
    }

    default public String resolveId() {
        return this.getParent().map(p -> p.resolveId() + ":").orElse("") + this.getId();
    }

    default public String resolveIdPath() {
        return this.getParent().map(p -> p.resolveIdPath() + "/").orElse("") + this.getId();
    }

    default public <T> Optional<T> resolvePeerInfo(String key, Class<T> clazz) {
        if (!this.getPeerInfo().containsKey(key)) {
            return this.getParent().flatMap(p -> p.resolvePeerInfo(key, (Object)clazz));
        }
        Object value = this.getPeerInfo().get(key);
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(clazz.cast(value));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    default public boolean isPeerInfoPresent(String key) {
        if (!this.getPeerInfo().containsKey(key)) {
            return this.getParent().map(p -> p.isPeerInfoPresent(key)).orElse(false);
        }
        return true;
    }

    default public <T> T resolvePeerInfo(String key, T defaultValue) {
        Class<?> val = this.resolvePeerInfo(key, (T)defaultValue.getClass());
        if (((Optional)((Object)val)).isPresent()) {
            return ((Optional)((Object)val)).get();
        }
        if (this.isPeerInfoPresent(key)) {
            return null;
        }
        return defaultValue;
    }
}

