/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.AbstractDataCenter;
import com.datastax.oss.simulacron.common.cluster.ClusterSpec;
import com.datastax.oss.simulacron.common.cluster.NodePropertiesBuilder;
import com.datastax.oss.simulacron.common.cluster.NodeSpec;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class DataCenterSpec
extends AbstractDataCenter<ClusterSpec, NodeSpec> {
    @JsonIgnore
    private final transient AtomicLong nodeCounter = new AtomicLong(0L);

    DataCenterSpec() {
        this(null, null, null, null, Collections.emptyMap(), null);
    }

    public DataCenterSpec(String name, Long id, String cassandraVersion, String dseVersion, Map<String, Object> peerInfo, ClusterSpec parent) {
        super(name, id, cassandraVersion, dseVersion, peerInfo, parent);
    }

    public NodeSpec.Builder addNode() {
        return new NodeSpec.Builder(this, this.nodeCounter.getAndIncrement(), UUID.randomUUID());
    }

    public static class Builder
    extends NodePropertiesBuilder<Builder, ClusterSpec> {
        Builder(ClusterSpec parent, Long id) {
            super(Builder.class, parent);
            this.id = id;
        }

        public DataCenterSpec build() {
            return new DataCenterSpec(this.name, this.id, this.cassandraVersion, this.dseVersion, (Map<String, Object>)this.peerInfo, (ClusterSpec)this.parent);
        }
    }
}

