/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.DataCenterStructure;
import com.datastax.oss.simulacron.common.cluster.Identifiable;
import com.datastax.oss.simulacron.common.cluster.NodeStructure;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ClusterStructure<D extends DataCenterStructure<?, N>, N extends NodeStructure>
extends Identifiable {
    public Collection<D> getDataCenters();

    @JsonIgnore
    default public Collection<N> getNodes() {
        return this.getDataCenters().stream().flatMap(dc -> dc.getNodes().stream()).collect(Collectors.toList());
    }

    default public D dc(long id) {
        return (D)((DataCenterStructure)this.getDataCenters().stream().filter(d -> d.getId() == id).findAny().orElse(null));
    }

    default public N node(long id) {
        return this.node(0L, id);
    }

    default public N node(long dcId, long nodeId) {
        return (N)((NodeStructure)Optional.ofNullable(this.dc(dcId)).map(d -> d.node(nodeId)).orElse(null));
    }
}

