/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.common.cluster;

import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.UUID;

@JsonIgnoreProperties(value={"active_connections"}, allowGetters=true)
public abstract class AbstractNodeProperties
implements NodeProperties {
    private final String name;
    private final Long id;
    @JsonProperty(value="host_id")
    private final UUID hostId;
    @JsonProperty(value="cassandra_version")
    private final String cassandraVersion;
    @JsonProperty(value="dse_version")
    private final String dseVersion;
    @JsonProperty(value="peer_info")
    private final Map<String, Object> peerInfo;

    AbstractNodeProperties(String name, Long id, UUID hostId, String cassandraVersion, String dseVersion, Map<String, Object> peerInfo) {
        this.name = name;
        this.id = id;
        this.hostId = hostId;
        this.cassandraVersion = cassandraVersion;
        this.dseVersion = dseVersion;
        this.peerInfo = peerInfo;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : (this.id != null ? this.id.toString() : null);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public UUID getHostId() {
        return this.hostId;
    }

    @Override
    public String getCassandraVersion() {
        return this.cassandraVersion;
    }

    @Override
    @JsonProperty(value="dse_version")
    public String getDSEVersion() {
        return this.dseVersion;
    }

    @Override
    public Map<String, Object> getPeerInfo() {
        return this.peerInfo;
    }

    @Override
    @JsonProperty(value="active_connections")
    public abstract Long getActiveConnections();

    String toStringWith(String extras) {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        str.append("{");
        if (this.id != null) {
            str.append("id=" + this.id);
            if (this.name != null && !this.name.equals(this.id.toString())) {
                str.append(", name='" + this.name + '\'');
            }
        } else {
            str.append("name='" + this.name + '\'');
        }
        if (this.cassandraVersion != null) {
            str.append(", cassandraVersion='" + this.cassandraVersion + '\'');
        }
        if (this.dseVersion != null) {
            str.append(", dseVersion='" + this.dseVersion + '\'');
        }
        if (!this.peerInfo.isEmpty()) {
            str.append(", peerInfo=" + this.peerInfo);
        }
        str.append(extras);
        str.append("}");
        return str.toString();
    }
}

