/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.selectors;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;

public final class SelectorSupport {
    private final BooleanExpression expression;
    private final String selector;

    public static SelectorSupport build(String selector, boolean enabled) throws JMSException {
        if (selector == null || selector.isEmpty()) {
            return null;
        }
        if (!enabled) {
            throw new InvalidSelectorException("Client-Side selectors are not enabled, please set enableClientSideEmulation=true");
        }
        BooleanExpression parse = SelectorParser.parse((String)selector);
        return new SelectorSupport(parse, selector);
    }

    public boolean matches(Message message) throws JMSException {
        MessageEvaluationContext context = new MessageEvaluationContext();
        ActiveMQMessage activeMQMessage = ActiveMQMessageTransformation.transformMessage((Message)message, null);
        context.setMessageReference((MessageReference)activeMQMessage);
        return this.expression.matches(context);
    }

    public String toString() {
        return "Selector=" + this.selector + ", exp=" + this.expression;
    }

    public String getSelector() {
        return this.selector;
    }

    public SelectorSupport(BooleanExpression expression, String selector) {
        this.expression = expression;
        this.selector = selector;
    }
}

