/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.messages;

import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.Utils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.apache.pulsar.client.api.TypedMessageBuilder;

public final class PulsarBytesMessage
extends PulsarMessage
implements BytesMessage {
    protected ByteArrayOutputStream stream;
    protected byte[] originalMessage;
    protected DataInputStream dataInputStream;
    protected DataOutputStream dataOutputStream;

    public PulsarBytesMessage fill(byte[] payload) throws JMSException {
        if (payload != null) {
            this.writeBytes(payload);
        }
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PulsarBytesMessage(byte[] payload) throws JMSException {
        try {
            this.dataInputStream = new DataInputStream(new ByteArrayInputStream(payload));
            this.originalMessage = payload;
            this.stream = null;
            this.dataOutputStream = null;
            this.writable = false;
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    public PulsarBytesMessage() {
        try {
            this.dataInputStream = null;
            this.stream = new ByteArrayOutputStream();
            this.dataOutputStream = new DataOutputStream(this.stream);
            this.originalMessage = null;
            this.writable = true;
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return byte[].class == c;
    }

    @Override
    protected void prepareForSend(TypedMessageBuilder<byte[]> producer) throws JMSException {
        try {
            if (this.stream != null) {
                this.dataOutputStream.flush();
                this.dataOutputStream.close();
                producer.value((Object)this.stream.toByteArray());
            } else {
                producer.value((Object)this.originalMessage);
            }
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    protected static JMSException handleException(Throwable t) throws JMSException {
        if (t instanceof EOFException) {
            throw new MessageEOFException(t + "");
        }
        throw Utils.handleException(t);
    }

    public byte readByte() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readByte();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public short readShort() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readShort();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public char readChar() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readChar();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public int readInt() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readInt();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public long readLong() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readLong();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public float readFloat() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readFloat();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public double readDouble() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readDouble();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public String readString() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readUTF();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeBoolean(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeByte(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeShort(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeChar(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeInt(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeLong(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeFloat(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeDouble(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeString(String value) throws JMSException {
        this.checkWritable();
        try {
            this.dataOutputStream.writeUTF(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWritable();
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            this.dataOutputStream.write(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWritable();
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            this.dataOutputStream.write(value, offset, length);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeObject(Object value) throws JMSException {
        block13: {
            this.checkWritable();
            if (value == null) {
                throw new NullPointerException("null not allowed here");
            }
            try {
                if (value instanceof Integer) {
                    this.writeInt((Integer)value);
                    break block13;
                }
                if (value instanceof String) {
                    this.writeUTF((String)value);
                    break block13;
                }
                if (value instanceof Short) {
                    this.writeShort((Short)value);
                    break block13;
                }
                if (value instanceof Long) {
                    this.writeLong((Long)value);
                    break block13;
                }
                if (value instanceof Double) {
                    this.writeDouble((Double)value);
                    break block13;
                }
                if (value instanceof Float) {
                    this.writeFloat(((Float)value).floatValue());
                    break block13;
                }
                if (value instanceof Byte) {
                    this.writeByte((Byte)value);
                    break block13;
                }
                if (value instanceof Character) {
                    this.writeChar(((Character)value).charValue());
                    break block13;
                }
                if (value instanceof Boolean) {
                    this.writeBoolean((Boolean)value);
                    break block13;
                }
                if (value instanceof byte[]) {
                    this.writeBytes((byte[])value);
                    break block13;
                }
                throw new MessageFormatException("Unsupported type " + value.getClass());
            }
            catch (Exception err) {
                throw PulsarBytesMessage.handleException(err);
            }
        }
    }

    public void clearBody() throws JMSException {
        this.writable = true;
        try {
            if (this.stream != null) {
                this.dataInputStream = new DataInputStream(new ByteArrayInputStream(this.stream.toByteArray()));
                this.stream = null;
                this.dataOutputStream = null;
            } else {
                this.stream = new ByteArrayOutputStream();
                this.dataOutputStream = new DataOutputStream(this.stream);
                this.originalMessage = null;
                this.dataInputStream = null;
            }
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void reset() throws JMSException {
        this.writable = false;
        try {
            if (this.stream != null) {
                this.dataOutputStream.flush();
                this.originalMessage = this.stream.toByteArray();
                this.dataInputStream = new DataInputStream(new ByteArrayInputStream(this.originalMessage));
                this.stream = null;
                this.dataOutputStream = null;
            } else {
                this.dataInputStream = new DataInputStream(new ByteArrayInputStream(this.originalMessage));
            }
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this.originalMessage.length;
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readUnsignedByte();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        try {
            return this.dataInputStream.readUnsignedShort();
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public String readUTF() throws JMSException {
        return this.readString();
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkReadable();
        if (value == null) {
            return -1;
        }
        try {
            return this.dataInputStream.read(value, 0, length);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.writeString(value);
    }

    @Override
    protected String messageType() {
        return "bytes";
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        if (c != byte[].class) {
            throw new MessageFormatException("only class byte[]");
        }
        this.reset();
        try {
            if (this.originalMessage != null) {
                byte[] byArray = this.originalMessage;
                return (T)byArray;
            }
            byte[] byArray = this.stream.toByteArray();
            return (T)byArray;
        }
        finally {
            this.reset();
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkReadable();
        if (value == null) {
            return -1;
        }
        try {
            return this.dataInputStream.read(value);
        }
        catch (Exception err) {
            throw PulsarBytesMessage.handleException(err);
        }
    }
}

