/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarMessageConsumer;
import com.datastax.oss.pulsar.jms.PulsarMessageProducer;
import com.datastax.oss.pulsar.jms.PulsarSession;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static ThreadLocal<CallbackContext> currentSession = new ThreadLocal();

    private Utils() {
    }

    public static JMSException handleException(Throwable cause) {
        while (cause instanceof CompletionException) {
            cause = cause.getCause();
        }
        if (cause instanceof JMSException) {
            return (JMSException)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof ClassCastException) {
            return (JMSException)new MessageFormatException("Invalid cast " + cause.getMessage()).initCause(cause);
        }
        if (cause instanceof NumberFormatException) {
            return (JMSException)new MessageFormatException("Invalid conversion " + cause.getMessage()).initCause(cause);
        }
        JMSException err = new JMSException(cause + "");
        err.initCause(cause);
        if (cause instanceof Exception) {
            err.setLinkedException((Exception)cause);
        } else {
            err.setLinkedException(new Exception(cause));
        }
        return err;
    }

    public static <T> T get(CompletableFuture<T> future) throws JMSException {
        try {
            return future.get();
        }
        catch (ExecutionException err) {
            throw Utils.handleException(err.getCause());
        }
        catch (InterruptedException err) {
            throw Utils.handleException(err);
        }
    }

    public static <T> T invoke(SupplierWithException<T> code) throws JMSException {
        try {
            return code.run();
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
    }

    public static void invoke(RunnableWithException code) throws JMSException {
        try {
            code.run();
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMessageListenerInSessionContext(PulsarSession session, PulsarMessageConsumer consumer, Runnable code) {
        currentSession.set(new CallbackContext(session, consumer, null));
        try {
            session.executeCriticalOperation(() -> {
                code.run();
                return null;
            });
        }
        catch (IllegalStateException err) {
            log.debug("Ignore error in listener", (Throwable)err);
        }
        catch (JMSException err) {
            log.error("Unexpected error in listener", (Throwable)err);
        }
        finally {
            currentSession.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCompletionListenerInSessionContext(PulsarSession session, PulsarMessageProducer producer, Runnable code) {
        currentSession.set(new CallbackContext(session, null, producer));
        try {
            session.executeCriticalOperation(() -> {
                code.run();
                return null;
            });
        }
        catch (IllegalStateException err) {
            log.debug("Ignore error in listener", (Throwable)err);
        }
        catch (JMSException err) {
            log.error("Unexpected error in listener", (Throwable)err);
        }
        finally {
            currentSession.remove();
        }
    }

    public static boolean isOnMessageListener(PulsarSession session, PulsarMessageConsumer consumer) {
        CallbackContext current = currentSession.get();
        return current != null && current.session == session && current.consumer == consumer;
    }

    public static void checkNotOnMessageListener(PulsarSession session) throws JMSException {
        CallbackContext current = currentSession.get();
        if (current != null && current.session == session && current.consumer != null) {
            throw new IllegalStateException("Cannot call this method inside a listener");
        }
    }

    public static void checkNotOnSessionCallback(PulsarSession session) throws JMSException {
        CallbackContext current = currentSession.get();
        if (current != null && current.session == session) {
            throw new IllegalStateException("Cannot call this method inside a callback");
        }
    }

    public static void checkNotOnMessageProducer(PulsarSession session, PulsarMessageProducer producer) throws JMSException {
        CallbackContext current = currentSession.get();
        if (current != null && current.session == session && (producer != null && current.producer == producer || producer == null || current.producer != null)) {
            throw new IllegalStateException("Cannot call this method inside a CompletionListener");
        }
    }

    public static void noException(RunnableWithException run) {
        try {
            run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(err);
        }
    }

    public static <T> T noException(SupplierWithException<T> run) {
        try {
            return run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(err);
        }
    }

    public static <T> T runtimeException(SupplierWithException<T> run) {
        try {
            return run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Utils.throwAsRuntimeException(err);
            return null;
        }
    }

    public static void runtimeException(RunnableWithException run) {
        try {
            run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Utils.throwAsRuntimeException(err);
        }
    }

    private static void throwAsRuntimeException(Exception err) {
        if (err instanceof NumberFormatException) {
            throw (MessageFormatRuntimeException)new MessageFormatRuntimeException("Illegal value: " + err.getMessage()).initCause((Throwable)err);
        }
        if (err instanceof IllegalStateException) {
            IllegalStateException jmsException = (IllegalStateException)((Object)err);
            throw new IllegalStateRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof TransactionRolledBackException) {
            TransactionRolledBackException jmsException = (TransactionRolledBackException)err;
            throw new TransactionRolledBackRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof InvalidDestinationException) {
            InvalidDestinationException jmsException = (InvalidDestinationException)err;
            throw new InvalidDestinationRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof InvalidClientIDException) {
            InvalidClientIDException jmsException = (InvalidClientIDException)err;
            throw new InvalidClientIDRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof InvalidSelectorException) {
            InvalidSelectorException jmsException = (InvalidSelectorException)err;
            throw new InvalidSelectorRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof MessageFormatException) {
            MessageFormatException jmsException = (MessageFormatException)err;
            throw new MessageFormatRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof MessageNotWriteableException) {
            MessageNotWriteableException jmsException = (MessageNotWriteableException)err;
            throw new MessageNotWriteableRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof JMSSecurityException) {
            JMSSecurityException jmsException = (JMSSecurityException)err;
            throw new JMSSecurityRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        if (err instanceof JMSException) {
            JMSException jmsException = (JMSException)((Object)err);
            throw new JMSRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), (Throwable)err);
        }
        JMSRuntimeException jms = new JMSRuntimeException("Generic error " + err.getMessage());
        jms.initCause((Throwable)err);
        throw jms;
    }

    private static class CallbackContext {
        final PulsarSession session;
        final PulsarMessageConsumer consumer;
        final PulsarMessageProducer producer;

        private CallbackContext(PulsarSession session, PulsarMessageConsumer consumer, PulsarMessageProducer producer) {
            this.session = session;
            this.consumer = consumer;
            this.producer = producer;
        }
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }

    public static interface SupplierWithException<T> {
        public T run() throws Exception;
    }
}

