/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.Utils;
import javax.jms.JMSException;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PulsarTemporaryDestination
extends PulsarDestination {
    private static final Logger log = LoggerFactory.getLogger(PulsarTemporaryDestination.class);
    private final PulsarSession session;

    public PulsarTemporaryDestination(String topicName, PulsarSession session) {
        super(topicName);
        this.session = session;
    }

    public PulsarSession getSession() {
        return this.session;
    }

    public final void delete() throws JMSException {
        try {
            log.info("Deleting {}", (Object)this);
            String fullQualifiedTopicName = this.session.getFactory().applySystemNamespace(this.topicName);
            TopicStats stats = this.session.getFactory().getPulsarAdmin().topics().getStats(fullQualifiedTopicName);
            log.info("Stats {}", (Object)stats);
            int numConsumers = stats.subscriptions.values().stream().mapToInt(s -> s.consumers.size()).sum();
            if (numConsumers > 0) {
                throw new JMSException("Cannot delete a temporary destination with active consumers");
            }
            this.session.getFactory().getPulsarAdmin().topics().delete(fullQualifiedTopicName, this.session.getFactory().isForceDeleteTemporaryDestinations(), true);
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
        finally {
            this.session.getConnection().removeTemporaryDestination(this);
        }
    }
}

