/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.PulsarQueue;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.selectors.SelectorSupport;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PulsarQueueBrowser
implements QueueBrowser {
    private static final Logger log = LoggerFactory.getLogger(PulsarQueueBrowser.class);
    private final PulsarSession session;
    private final PulsarQueue queue;
    private final Reader<byte[]> reader;
    private final SelectorSupport selectorSupport;

    public PulsarQueueBrowser(PulsarSession session, Queue queue, String selector) throws JMSException {
        session.checkNotClosed();
        this.session = session;
        this.queue = (PulsarQueue)queue;
        this.reader = session.getFactory().createReaderForBrowser(this.queue);
        this.selectorSupport = SelectorSupport.build(selector, true);
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        return this.selectorSupport != null ? this.selectorSupport.getSelector() : null;
    }

    public Enumeration getEnumeration() throws JMSException {
        return new Enumeration(){
            PulsarMessage nextMessage;
            boolean finished;

            @Override
            public boolean hasMoreElements() {
                this.ensureNext();
                return !this.finished;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                PulsarMessage res = this.nextMessage;
                this.nextMessage = null;
                return res;
            }

            private void ensureNext() {
                Utils.runtimeException(() -> {
                    while (!this.finished && this.nextMessage == null) {
                        if (!PulsarQueueBrowser.this.reader.hasMessageAvailable()) {
                            this.finished = true;
                            return;
                        }
                        this.nextMessage = PulsarMessage.decode(null, (Message<byte[]>)PulsarQueueBrowser.this.reader.readNext(1000, TimeUnit.MILLISECONDS));
                        if (this.nextMessage == null) {
                            log.info("no message received from browser in time");
                            this.finished = true;
                            return;
                        }
                        if (PulsarQueueBrowser.this.selectorSupport != null && !PulsarQueueBrowser.this.selectorSupport.matches(this.nextMessage)) {
                            log.info("skip non matching message {}", (Object)this.nextMessage);
                            this.nextMessage = null;
                            continue;
                        }
                        return;
                    }
                });
            }
        };
    }

    public void close() throws JMSException {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.session.getFactory().removeReader(this.reader);
    }
}

