/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.messages.PulsarBytesMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarMapMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarObjectMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarSimpleMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarStreamMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarTextMessage;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PulsarMessageProducer
implements MessageProducer,
TopicPublisher,
QueueSender {
    private static final Logger log = LoggerFactory.getLogger(PulsarMessageProducer.class);
    private final PulsarSession session;
    private final PulsarDestination defaultDestination;
    private final boolean jms20;
    private boolean closed;
    private boolean disableMessageId;
    private boolean disableMessageTimestamp;
    private int deliveryMode = 2;
    private int priority = 4;
    private long defaultTimeToLive = 0L;
    private long defaultDeliveryDelay = 0L;

    public PulsarMessageProducer(PulsarSession session, Destination defaultDestination) throws JMSException {
        this.jms20 = session.isJms20();
        session.checkNotClosed();
        this.session = session;
        try {
            this.defaultDestination = (PulsarDestination)defaultDestination;
        }
        catch (ClassCastException err) {
            throw new InvalidDestinationException("Invalid destination type " + defaultDestination.getClass());
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkNotClosed();
        this.disableMessageId = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkNotClosed();
        return this.disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkNotClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkNotClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkNotClosed();
        PulsarMessageProducer.validateDeliveryMode(deliveryMode);
        this.deliveryMode = deliveryMode;
    }

    private static void validateDeliveryMode(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new JMSException("Invalid deliveryMode " + deliveryMode);
            }
        }
    }

    public int getDeliveryMode() throws JMSException {
        this.checkNotClosed();
        return this.deliveryMode;
    }

    private void checkNotClosed() throws JMSException {
        this.session.checkNotClosed();
        if (this.closed) {
            throw new IllegalStateException("this producer is closed");
        }
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkNotClosed();
        this.validatePriority(defaultPriority);
        this.priority = defaultPriority;
    }

    private void validatePriority(int defaultPriority) throws JMSException {
        if (defaultPriority < 0 || defaultPriority > 10) {
            throw new JMSException("invalid priority " + defaultPriority);
        }
    }

    public int getPriority() throws JMSException {
        this.checkNotClosed();
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkNotClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkNotClosed();
        return this.defaultTimeToLive;
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.checkNotClosed();
        this.defaultDeliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() throws JMSException {
        this.checkNotClosed();
        return this.defaultDeliveryDelay;
    }

    public Destination getDestination() throws JMSException {
        this.checkNotClosed();
        return this.defaultDestination;
    }

    public void close() throws JMSException {
        Utils.checkNotOnMessageProducer(this.session, this);
        this.closed = true;
    }

    public void send(Message message) throws JMSException {
        message.setJMSDeliveryMode(this.deliveryMode);
        message.setJMSPriority(this.priority);
        this.validateMessageSend(message, this.defaultDestination, true, 0L, this.deliveryMode, this.priority);
        this.sendMessage(this.defaultDestination, message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.validateMessageSend(message, this.defaultDestination, true, timeToLive, deliveryMode, priority);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.applyTimeToLive(message, timeToLive);
        this.sendMessage(this.defaultDestination, message);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.checkNoDefaultDestinationSet();
        this.validateMessageSend(message, destination, false, 0L, this.deliveryMode, this.priority);
        message.setJMSDeliveryMode(this.deliveryMode);
        message.setJMSPriority(this.priority);
        this.sendMessage(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkNoDefaultDestinationSet();
        this.validateMessageSend(message, destination, false, timeToLive, deliveryMode, priority);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.applyTimeToLive(message, timeToLive);
        this.sendMessage(destination, message);
    }

    private void checkNoDefaultDestinationSet() {
        if (this.defaultDestination != null) {
            throw new UnsupportedOperationException("you cannot use this producer with another destination");
        }
    }

    private void validateMessageSend(Message message, Destination destination, boolean isDefaultDestination, long timeToLive, int deliveryMode, int priority) throws JMSException {
        this.checkNotClosed();
        if (message == null) {
            throw new MessageFormatException("Invalid null message");
        }
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException("Invalid deliveryMode " + deliveryMode);
        }
        this.validatePriority(priority);
        if (destination == null) {
            if (isDefaultDestination) {
                throw new UnsupportedOperationException("please set a destination");
            }
            throw new InvalidDestinationException("destination is null");
        }
        if (timeToLive > 0L && !this.session.getFactory().isEnableClientSideEmulation()) {
            throw new JMSException("timeToLive not enabled, please set jms.enableClientSideEmulation=true");
        }
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        message.setJMSDeliveryMode(this.deliveryMode);
        message.setJMSPriority(this.priority);
        this.validateCompletionListener(completionListener);
        if (!this.jms20) {
            PulsarMessageProducer.validateDeliveryMode(this.deliveryMode);
        }
        try {
            this.validateMessageSend(message, this.defaultDestination, true, 0L, this.deliveryMode, this.priority);
        }
        catch (JMSException err) {
            completionListener.onException(message, (Exception)((Object)err));
            return;
        }
        message.setJMSDeliveryMode(this.deliveryMode);
        message.setJMSPriority(this.priority);
        this.sendMessage(this.defaultDestination, message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.validateCompletionListener(completionListener);
        if (!this.jms20) {
            PulsarMessageProducer.validateDeliveryMode(deliveryMode);
            this.validatePriority(priority);
        }
        try {
            this.validateMessageSend(message, this.defaultDestination, true, timeToLive, deliveryMode, priority);
        }
        catch (JMSException err) {
            completionListener.onException(message, (Exception)((Object)err));
            return;
        }
        message.setJMSDestination((Destination)this.defaultDestination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.applyTimeToLive(message, timeToLive);
        PulsarMessage pulsarMessage = this.prepareMessageForSend(message);
        this.sendMessage(this.defaultDestination, pulsarMessage, completionListener);
    }

    private PulsarMessage prepareMessageForSend(Message message) throws JMSException {
        PulsarMessage res;
        if (message == null) {
            throw new IllegalArgumentException("Cannot send a null message");
        }
        if (!(message instanceof PulsarMessage)) {
            PulsarMessage dest;
            BytesMessage sm;
            if (message instanceof TextMessage) {
                res = new PulsarTextMessage(((TextMessage)message).getText());
            } else if (message instanceof BytesMessage) {
                sm = (BytesMessage)message;
                sm.reset();
                byte[] buffer = new byte[(int)sm.getBodyLength()];
                sm.readBytes(buffer);
                PulsarBytesMessage dest2 = new PulsarBytesMessage(buffer);
                res = dest2;
            } else if (message instanceof MapMessage) {
                sm = (MapMessage)message;
                dest = new PulsarMapMessage();
                Enumeration en = sm.getMapNames();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    ((PulsarMapMessage)dest).setObject(name, sm.getObject(name));
                }
                res = dest;
            } else if (message instanceof ObjectMessage) {
                res = new PulsarObjectMessage(((ObjectMessage)message).getObject());
            } else if (message instanceof StreamMessage) {
                sm = (StreamMessage)message;
                sm.reset();
                dest = new PulsarStreamMessage();
                try {
                    while (true) {
                        Object object = sm.readObject();
                        ((PulsarStreamMessage)dest).writeObject(object);
                    }
                }
                catch (MessageEOFException end) {
                    res = dest;
                }
            } else {
                res = new PulsarSimpleMessage();
            }
            res.setWritable(true);
            Enumeration en = message.getPropertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                res.setObjectProperty(name, message.getObjectProperty(name));
            }
            res.setJMSCorrelationIDAsBytes(message.getJMSCorrelationIDAsBytes());
            res.setJMSDeliveryMode(message.getJMSDeliveryMode());
            res.setJMSPriority(message.getJMSPriority());
            res.setJMSDestination(message.getJMSDestination());
            res.setJMSDeliveryTime(message.getJMSDeliveryTime());
        } else {
            res = (PulsarMessage)message;
        }
        res.setWritable(true);
        res.setStringProperty("JMSConnectionID", this.session.getConnection().getConnectionId());
        return res;
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.validateCompletionListener(completionListener);
        this.checkNoDefaultDestinationSet();
        if (!this.jms20) {
            PulsarMessageProducer.validateDeliveryMode(this.deliveryMode);
        }
        try {
            this.validateMessageSend(message, destination, false, 0L, this.deliveryMode, this.priority);
        }
        catch (JMSException err) {
            completionListener.onException(message, (Exception)((Object)err));
            return;
        }
        message.setJMSDeliveryMode(this.deliveryMode);
        message.setJMSPriority(this.priority);
        this.sendMessage(destination, message, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.validateCompletionListener(completionListener);
        this.checkNoDefaultDestinationSet();
        if (!this.jms20) {
            PulsarMessageProducer.validateDeliveryMode(deliveryMode);
            this.validatePriority(priority);
        }
        try {
            this.validateMessageSend(message, destination, false, timeToLive, deliveryMode, priority);
        }
        catch (JMSException err) {
            completionListener.onException(message, (Exception)((Object)err));
            return;
        }
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.applyTimeToLive(message, timeToLive);
        this.sendMessage(destination, message, completionListener);
    }

    private void applyTimeToLive(Message message, long timeToLive) throws JMSException {
        if (timeToLive > 0L) {
            long time = System.currentTimeMillis() + timeToLive;
            message.setLongProperty("JMSExpiration", System.currentTimeMillis() + timeToLive);
            message.setJMSExpiration(time);
        }
    }

    private void validateCompletionListener(CompletionListener completionListener) {
        if (completionListener == null) {
            throw new IllegalArgumentException("IllegalArgumentException is null");
        }
    }

    private void sendMessage(Destination defaultDestination, Message message) throws JMSException {
        if (message == null) {
            throw new MessageFormatException("null message");
        }
        Producer<byte[]> producer = this.session.getFactory().getProducerForDestination((PulsarDestination)defaultDestination, this.session.getTransacted());
        message.setJMSDestination(defaultDestination);
        PulsarMessage pulsarMessage = this.prepareMessageForSend(message);
        TypedMessageBuilder typedMessageBuilder = this.session.getTransacted() ? producer.newMessage(this.session.getTransaction()) : producer.newMessage();
        if (this.defaultDeliveryDelay > 0L) {
            typedMessageBuilder.deliverAfter(this.defaultDeliveryDelay, TimeUnit.MILLISECONDS);
        }
        pulsarMessage.send((TypedMessageBuilder<byte[]>)typedMessageBuilder, this.disableMessageTimestamp, this.session);
        if (message != pulsarMessage) {
            this.applyBackMessageProperties(message, pulsarMessage);
        }
    }

    private void sendMessage(Destination defaultDestination, final Message message, final CompletionListener completionListener) throws JMSException {
        if (message == null) {
            throw new MessageFormatException("null message");
        }
        Producer<byte[]> producer = this.session.getFactory().getProducerForDestination((PulsarDestination)defaultDestination, this.session.getTransacted());
        message.setJMSDestination(defaultDestination);
        final PulsarMessage pulsarMessage = this.prepareMessageForSend(message);
        CompletionListener finalCompletionListener = completionListener;
        if (pulsarMessage != message) {
            finalCompletionListener = new CompletionListener(){

                public void onCompletion(Message completedMessage) {
                    PulsarMessageProducer.this.applyBackMessageProperties(message, pulsarMessage);
                    completionListener.onCompletion(message);
                }

                public void onException(Message completedMessage, Exception e) {
                    PulsarMessageProducer.this.applyBackMessageProperties(message, pulsarMessage);
                    completionListener.onException(message, e);
                }
            };
        }
        TypedMessageBuilder typedMessageBuilder = this.session.getTransacted() ? producer.newMessage(this.session.getTransaction()) : producer.newMessage();
        pulsarMessage.sendAsync((TypedMessageBuilder<byte[]>)typedMessageBuilder, finalCompletionListener, this.session, this, this.disableMessageTimestamp);
    }

    private void applyBackMessageProperties(Message message, PulsarMessage pulsarMessage) {
        Utils.runtimeException(() -> {
            message.setJMSTimestamp(pulsarMessage.getJMSTimestamp());
            message.setJMSExpiration(pulsarMessage.getJMSExpiration());
            message.setJMSMessageID(pulsarMessage.getJMSMessageID());
        });
    }

    public Queue getQueue() throws JMSException {
        this.checkNotClosed();
        if (this.defaultDestination.isQueue()) {
            return (Queue)this.defaultDestination;
        }
        throw new JMSException("Created on a topic");
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int i, int i1, long l) throws JMSException {
        this.send((Destination)queue, message, i, i1, l);
    }

    public Topic getTopic() throws JMSException {
        this.checkNotClosed();
        if (this.defaultDestination.isTopic()) {
            return (Topic)this.defaultDestination;
        }
        throw new JMSException("Created on a queue");
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Message message, int i, int i1, long l) throws JMSException {
        this.send(message, i, i1, l);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(Topic topic, Message message, int i, int i1, long l) throws JMSException {
        this.send((Destination)topic, message, i, i1, l);
    }
}

