/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarMessageConsumer;
import com.datastax.oss.pulsar.jms.PulsarMessageProducer;
import com.datastax.oss.pulsar.jms.PulsarQueue;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.PulsarTopic;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.messages.PulsarBytesMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarMapMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarObjectMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarSimpleMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarStreamMessage;
import com.datastax.oss.pulsar.jms.messages.PulsarTextMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarMessage
implements javax.jms.Message {
    private static final Logger log = LoggerFactory.getLogger(PulsarMessage.class);
    private volatile String messageId;
    protected boolean writable = true;
    private volatile long jmsTimestamp;
    private byte[] correlationId;
    private Destination jmsReplyTo;
    private Destination destination;
    private int deliveryMode = 2;
    private String jmsType;
    private boolean jmsRedelivered;
    private volatile long jmsExpiration;
    private volatile long jmsDeliveryTime;
    private int jmsPriority = 4;
    protected final Map<String, String> properties = new HashMap<String, String>();
    private PulsarMessageConsumer consumer;
    private boolean negativeAcked;
    private Message<byte[]> receivedPulsarMessage;

    public String getJMSMessageID() throws JMSException {
        return this.messageId;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.messageId = id;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.jmsTimestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.jmsTimestamp = timestamp;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.correlationId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.correlationId = correlationID;
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.correlationId = correlationID.getBytes(StandardCharsets.UTF_8);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.correlationId != null ? new String(this.correlationId, StandardCharsets.UTF_8) : null;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.jmsReplyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.jmsReplyTo = replyTo;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.destination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.destination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.jmsRedelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.jmsRedelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        return this.jmsType;
    }

    public void setJMSType(String type) throws JMSException {
        this.jmsType = type;
    }

    public long getJMSExpiration() throws JMSException {
        return this.jmsExpiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.jmsExpiration = expiration;
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.jmsDeliveryTime;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.jmsDeliveryTime = deliveryTime;
    }

    public int getJMSPriority() throws JMSException {
        return this.jmsPriority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.jmsPriority = priority;
    }

    public void clearProperties() throws JMSException {
        this.properties.clear();
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean(value.toString());
        }
        throw new MessageFormatException("Unsupported conversion to boolean for " + value);
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("null not allowed");
        }
        if (value instanceof Byte) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            return Utils.invoke(() -> Byte.parseByte(value.toString()));
        }
        throw new MessageFormatException("Unsupported conversion");
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("null not allowed");
        }
        if (value instanceof Byte || value instanceof Short) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            return Utils.invoke(() -> Short.parseShort(value.toString()));
        }
        throw new MessageFormatException("Unsupported conversion");
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("null not allowed");
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Utils.invoke(() -> Integer.parseInt(value.toString()));
        }
        throw new MessageFormatException("Unsupported conversion");
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NumberFormatException("null not allowed");
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Utils.invoke(() -> Long.parseLong(value.toString()));
        }
        throw new MessageFormatException("Unsupported conversion");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("null not allowed");
        }
        if (value instanceof Float) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Utils.invoke(() -> Float.valueOf(Float.parseFloat(value.toString()))).floatValue();
        }
        throw new MessageFormatException("Unsuppported");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        if (value == null) {
            throw new NullPointerException("null not allowed");
        }
        if (value instanceof Float || value instanceof Double) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Utils.invoke(() -> Double.parseDouble(value.toString()));
        }
        throw new MessageFormatException("Unsuppported");
    }

    public String getStringProperty(String name) throws JMSException {
        return Utils.invoke(() -> this.properties.getOrDefault(name, null));
    }

    public Object getObjectProperty(String name) throws JMSException {
        return Utils.invoke(() -> {
            String type;
            String value = this.properties.getOrDefault(name, null);
            if (value == null) {
                return null;
            }
            switch (type = this.properties.getOrDefault(PulsarMessage.propertyType(name), "string")) {
                case "string": {
                    return value;
                }
                case "boolean": {
                    return Boolean.valueOf(Boolean.parseBoolean(value));
                }
                case "float": {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case "double": {
                    return Double.valueOf(Double.parseDouble(value));
                }
                case "int": {
                    return Integer.valueOf(Integer.parseInt(value));
                }
                case "short": {
                    return Short.valueOf(Short.parseShort(value));
                }
                case "byte": {
                    return Byte.valueOf(Byte.parseByte(value));
                }
                case "long": {
                    return Long.valueOf(Long.parseLong(value));
                }
            }
            return value;
        });
    }

    public Enumeration getPropertyNames() throws JMSException {
        return Collections.enumeration(this.properties.keySet().stream().filter(n -> !n.endsWith("_jsmtype")).collect(Collectors.toList()));
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Boolean.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "boolean");
    }

    private static String propertyType(String name) {
        return name + "_jsmtype";
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Byte.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "byte");
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Short.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "short");
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Integer.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "int");
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Long.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "long");
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Float.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "float");
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, Double.toString(value));
        this.properties.put(PulsarMessage.propertyType(name), "double");
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkWritableProperty(name);
        this.properties.put(name, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkWritableProperty(name);
        if (value != null) {
            if (value instanceof String) {
                this.setStringProperty(name, (String)value);
                return;
            } else if (value instanceof Boolean) {
                this.setBooleanProperty(name, (Boolean)value);
                return;
            } else if (value instanceof Integer) {
                this.setIntProperty(name, (Integer)value);
                return;
            } else if (value instanceof Long) {
                this.setLongProperty(name, (Long)value);
                return;
            } else if (value instanceof Float) {
                this.setFloatProperty(name, ((Float)value).floatValue());
                return;
            } else if (value instanceof Short) {
                this.setShortProperty(name, (Short)value);
                return;
            } else if (value instanceof Double) {
                this.setDoubleProperty(name, (Double)value);
                return;
            } else {
                if (!(value instanceof Byte)) throw new MessageFormatException("Invalid property type " + value.getClass());
                this.setByteProperty(name, (Byte)value);
            }
            return;
        } else {
            this.properties.put(PulsarMessage.propertyType(name), "null");
            this.properties.put(name, null);
        }
    }

    public void acknowledge() throws JMSException {
        this.consumer.checkNotClosed();
        this.consumer.getSession().acknowledgeAllMessages();
    }

    void acknowledgeInternal() throws JMSException {
        if (this.consumer == null) {
            throw new IllegalStateException("not received by a consumer");
        }
        if (this.negativeAcked) {
            return;
        }
        try {
            this.consumer.acknowledge(this.receivedPulsarMessage, this);
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    boolean isNegativeAcked() {
        return this.negativeAcked;
    }

    public void negativeAck() throws JMSException {
        if (this.consumer == null) {
            throw new IllegalStateException("not received by a consumer");
        }
        this.consumer.checkNotClosed();
        try {
            this.consumer.negativeAck(this.receivedPulsarMessage);
            this.negativeAcked = true;
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    protected final void checkWritable() throws MessageNotWriteableException {
        if (!this.writable) {
            throw new MessageNotWriteableException("not writable");
        }
    }

    protected final void checkReadable() throws MessageNotReadableException {
        if (this.writable) {
            throw new MessageNotReadableException("not readable");
        }
    }

    protected final void checkWritableProperty(String name) throws JMSException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid map key " + name);
        }
        if (!this.writable) {
            throw new MessageNotWriteableException("Not writeable");
        }
    }

    protected abstract String messageType();

    final void sendAsync(TypedMessageBuilder<byte[]> message, CompletionListener completionListener, PulsarSession session, PulsarMessageProducer pulsarProducer, boolean disableMessageTimestamp) throws JMSException {
        this.prepareForSend(message);
        this.fillSystemPropertiesBeforeSend(message, disableMessageTimestamp, session);
        message.sendAsync().whenComplete((messageIdFromServer, error) -> Utils.executeCompletionListenerInSessionContext(session, pulsarProducer, () -> {
            this.writable = false;
            if (error != null) {
                completionListener.onException((javax.jms.Message)this, (Exception)Utils.handleException(error));
            } else {
                this.assignSystemMessageId((MessageId)messageIdFromServer);
                completionListener.onCompletion((javax.jms.Message)this);
            }
        }));
    }

    private void fillSystemPropertiesBeforeSend(TypedMessageBuilder<byte[]> message, boolean disableMessageTimestamp, PulsarSession session) throws MessageNotWriteableException {
        this.consumer = null;
        message.properties(this.properties);
        message.property("JMSPulsarMessageType", this.messageType());
        if (this.messageId != null) {
            message.property("JMSMessageId", this.messageId);
        }
        if (this.jmsReplyTo != null) {
            message.property("JMSReplyTo", session.getFactory().applySystemNamespace(((PulsarDestination)this.jmsReplyTo).topicName));
            if (((PulsarDestination)this.jmsReplyTo).isTopic()) {
                message.property("JMSReplyToType", "topic");
            }
        }
        if (this.jmsType != null) {
            message.property("JMSType", this.jmsType);
        }
        if (this.correlationId != null) {
            message.property("JMSCorrelationID", Base64.getEncoder().encodeToString(this.correlationId));
        }
        if (this.deliveryMode != 2) {
            message.property("JMSDeliveryMode", this.deliveryMode + "");
        }
        if (this.jmsPriority != 4) {
            message.property("JMSPriority", this.jmsPriority + "");
        }
        this.jmsTimestamp = System.currentTimeMillis();
        if (!disableMessageTimestamp) {
            message.eventTime(this.jmsTimestamp);
        }
        this.jmsDeliveryTime = this.jmsTimestamp;
        if (this.jmsDeliveryTime == 0L) {
            this.jmsDeliveryTime = System.currentTimeMillis();
        }
        message.property("JMSDeliveryTime", this.jmsDeliveryTime + "");
        String JMSXGroupID = this.properties.get("JMSXGroupID");
        if (JMSXGroupID != null) {
            message.key(JMSXGroupID);
        }
    }

    final void send(TypedMessageBuilder<byte[]> producer, boolean disableMessageTimestamp, PulsarSession session) throws JMSException {
        this.prepareForSend(producer);
        this.fillSystemPropertiesBeforeSend(producer, disableMessageTimestamp, session);
        MessageId messageIdFromServer = Utils.invoke(() -> producer.send());
        this.assignSystemMessageId(messageIdFromServer);
    }

    protected abstract void prepareForSend(TypedMessageBuilder<byte[]> var1) throws JMSException;

    static PulsarMessage decode(PulsarMessageConsumer consumer, Message<byte[]> msg) throws JMSException {
        if (msg == null) {
            return null;
        }
        String type = msg.getProperty("JMSPulsarMessageType");
        if (type == null) {
            type = "bytes";
        }
        byte[] value = (byte[])msg.getValue();
        switch (type) {
            case "map": {
                return new PulsarMapMessage(value).applyMessage(msg, consumer);
            }
            case "object": {
                return new PulsarObjectMessage(value).applyMessage(msg, consumer);
            }
            case "stream": {
                return new PulsarStreamMessage(value).applyMessage(msg, consumer);
            }
            case "bytes": {
                return new PulsarBytesMessage(value).applyMessage(msg, consumer);
            }
            case "text": {
                return new PulsarTextMessage(value).applyMessage(msg, consumer);
            }
        }
        return new PulsarSimpleMessage().applyMessage(msg, consumer);
    }

    protected PulsarMessage applyMessage(Message<byte[]> msg, PulsarMessageConsumer consumer) {
        String jmsReplyTo;
        this.writable = false;
        this.properties.putAll(msg.getProperties());
        if (consumer != null) {
            this.destination = consumer.getDestination();
        }
        if ((jmsReplyTo = msg.getProperty("JMSReplyTo")) != null) {
            String jmsReplyToType;
            switch (jmsReplyToType = msg.getProperty("JMSReplyToType") + "") {
                case "topic": {
                    this.jmsReplyTo = new PulsarTopic(jmsReplyTo);
                    break;
                }
                default: {
                    this.jmsReplyTo = new PulsarQueue(jmsReplyTo);
                }
            }
        }
        if (msg.hasProperty("JMSType")) {
            this.jmsType = msg.getProperty("JMSType");
        }
        if (msg.hasProperty("JMSMessageId")) {
            this.messageId = msg.getProperty("JMSMessageId");
        }
        this.assignSystemMessageId(msg.getMessageId());
        if (msg.hasProperty("JMSCorrelationID")) {
            this.correlationId = Base64.getDecoder().decode(msg.getProperty("JMSCorrelationID"));
        }
        if (msg.hasProperty("JMSPriority")) {
            try {
                this.jmsPriority = Integer.parseInt(msg.getProperty("JMSPriority"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (msg.hasProperty("JMSDeliveryMode")) {
            try {
                this.deliveryMode = Integer.parseInt(msg.getProperty("JMSDeliveryMode"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (msg.hasProperty("JMSExpiration")) {
            try {
                this.jmsExpiration = Long.parseLong(msg.getProperty("JMSExpiration"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.jmsDeliveryTime = this.jmsTimestamp = msg.getEventTime();
        if (msg.hasProperty("JMSDeliveryTime")) {
            try {
                this.jmsDeliveryTime = Long.parseLong(msg.getProperty("JMSDeliveryTime"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.properties.put("JMSXDeliveryCount", msg.getRedeliveryCount() + 1 + "");
        if (msg.getKey() != null) {
            this.properties.put("JMSXGroupID", msg.getKey());
        } else {
            this.properties.put("JMSXGroupID", "");
        }
        if (!this.properties.containsKey("JMSXGroupSeq")) {
            this.properties.put("JMSXGroupSeq", msg.getSequenceId() + "");
        }
        this.jmsRedelivered = msg.getRedeliveryCount() > 0;
        this.receivedPulsarMessage = msg;
        this.consumer = consumer;
        return this;
    }

    private void assignSystemMessageId(MessageId msgId) {
        if (this.messageId == null) {
            this.messageId = "ID:" + msgId;
        }
    }

    protected static void validateWritableObject(Object value) throws MessageFormatException {
        if (value == null) {
            return;
        }
        if (!(value instanceof Integer || value instanceof String || value instanceof Short || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof byte[])) {
            throw new MessageFormatException("Unsupported type " + value.getClass());
        }
    }

    public boolean isReceivedFromConsumer(PulsarMessageConsumer consumer) {
        return this.consumer == consumer;
    }

    protected static JMSException handleExceptionAccordingToMessageSpecs(Throwable t) throws JMSException {
        if (t instanceof NumberFormatException) {
            throw (NumberFormatException)t;
        }
        if (t instanceof EOFException) {
            throw new MessageEOFException(t + "");
        }
        throw Utils.handleException(t);
    }

    public void setWritable(boolean b) {
        this.writable = b;
    }
}

