/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarJMSContext;
import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.PulsarMessageProducer;
import com.datastax.oss.pulsar.jms.Utils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;

public class PulsarJMSProducer
implements JMSProducer {
    private final PulsarJMSContext parent;
    private boolean disableMessageId;
    private boolean disableMessageTimestamp;
    private int deliveryMode = 2;
    private int priority = 4;
    private long deliveryDelay = 0L;
    private long timeToLive = 0L;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private CompletionListener completionListener;
    private byte[] correlationID;
    private String jmsType;
    private Destination jmsReplyTo;

    public PulsarJMSProducer(PulsarJMSContext parent) {
        this.parent = parent;
    }

    public JMSProducer send(Destination destination, Message message) {
        Utils.runtimeException(() -> this.getProducerAndSend(destination, message));
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        Utils.runtimeException(() -> this.getProducerAndSend(destination, (Message)this.parent.session.createTextMessage(body)));
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        Utils.runtimeException(() -> this.getProducerAndSend(destination, (Message)this.parent.session.createMapMessage(body)));
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        Utils.runtimeException(() -> this.getProducerAndSend(destination, this.parent.session.createBytesMessage().fill(body)));
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        Utils.runtimeException(() -> this.getProducerAndSend(destination, (Message)this.parent.session.createObjectMessage(body)));
        return this;
    }

    private void getProducerAndSend(Destination destination, Message message) throws JMSException {
        if (message == null) {
            if (this.completionListener != null) {
                this.completionListener.onException(null, (Exception)new MessageFormatRuntimeException("message is null"));
                return;
            }
            throw new MessageFormatException("message is null");
        }
        if (destination == null) {
            if (this.completionListener != null) {
                this.completionListener.onException(message, (Exception)new InvalidDestinationRuntimeException("message is null"));
                return;
            }
            throw new InvalidDestinationException("destination is null");
        }
        PulsarMessageProducer producer = this.parent.session.createProducer(null);
        producer.setDisableMessageID(this.disableMessageId);
        producer.setDisableMessageTimestamp(this.disableMessageTimestamp);
        producer.setDeliveryMode(this.deliveryMode);
        producer.setPriority(this.priority);
        producer.setDeliveryDelay(this.deliveryDelay);
        producer.setTimeToLive(this.timeToLive);
        for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
            message.setObjectProperty(prop.getKey(), prop.getValue());
        }
        message.setJMSPriority(this.priority);
        message.setJMSCorrelationIDAsBytes(this.correlationID);
        message.setJMSType(this.jmsType);
        message.setJMSReplyTo(this.jmsReplyTo);
        if (this.completionListener != null) {
            producer.send(destination, message, this.deliveryMode, this.priority, this.timeToLive, this.completionListener);
        } else {
            producer.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
        }
    }

    public JMSProducer setDisableMessageID(boolean value) {
        this.disableMessageId = value;
        return this;
    }

    public boolean getDisableMessageID() {
        return this.disableMessageId;
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        this.disableMessageTimestamp = value;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid deliveryMode " + deliveryMode);
            }
        }
        this.deliveryMode = deliveryMode;
        return this;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public JMSProducer setPriority(int priority) {
        if (priority < 0 || priority > 10) {
            throw new JMSRuntimeException("Invalid priority " + priority);
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    private void setPropertyInternal(String name, Object value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty property name");
        }
        Utils.runtimeException(() -> PulsarMessage.validateWritableObject(value));
        this.properties.put(name, value);
    }

    public JMSProducer setProperty(String name, float value) {
        this.setPropertyInternal(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.setPropertyInternal(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        this.properties.clear();
        return this;
    }

    public boolean propertyExists(String name) {
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        switch (this.properties.getOrDefault(name, "false").toString()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new MessageFormatRuntimeException("Invalid value for boolean");
    }

    public byte getByteProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new NumberFormatException();
        }
        Object currentValue = this.properties.getOrDefault(name, "0");
        if (currentValue instanceof Number) {
            if (!(currentValue instanceof Byte)) {
                throw new MessageFormatRuntimeException("unsupported conversion");
            }
            return ((Number)currentValue).byteValue();
        }
        return Utils.runtimeException(() -> Byte.parseByte(currentValue.toString()));
    }

    public short getShortProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new NumberFormatException();
        }
        Object currentValue = this.properties.getOrDefault(name, "0");
        if (currentValue instanceof Number) {
            if (!(currentValue instanceof Short) && !(currentValue instanceof Byte)) {
                throw new MessageFormatRuntimeException("unsupported conversion");
            }
            return ((Number)currentValue).shortValue();
        }
        return Utils.runtimeException(() -> Short.parseShort(currentValue.toString()));
    }

    public int getIntProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new NumberFormatException();
        }
        Object currentValue = this.properties.getOrDefault(name, "0");
        if (currentValue instanceof Number) {
            if (!(currentValue instanceof Short || currentValue instanceof Integer || currentValue instanceof Byte)) {
                throw new MessageFormatRuntimeException("unsupported conversion");
            }
            return ((Number)currentValue).intValue();
        }
        return Utils.runtimeException(() -> Integer.parseInt(currentValue.toString()));
    }

    public long getLongProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new NumberFormatException();
        }
        Object currentValue = this.properties.getOrDefault(name, "0");
        if (currentValue instanceof Number) {
            if (!(currentValue instanceof Short || currentValue instanceof Integer || currentValue instanceof Byte || currentValue instanceof Long)) {
                throw new MessageFormatRuntimeException("unsupported conversion");
            }
            return ((Number)currentValue).longValue();
        }
        return Utils.runtimeException(() -> Long.parseLong(currentValue.toString()));
    }

    public float getFloatProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new NullPointerException();
        }
        Object currentValue = this.properties.getOrDefault(name, "0");
        if (currentValue instanceof Number) {
            if (!(currentValue instanceof Float)) {
                throw new MessageFormatRuntimeException("unsupported conversion");
            }
            return ((Float)currentValue).floatValue();
        }
        return Utils.runtimeException(() -> Float.valueOf(Float.parseFloat(currentValue.toString()))).floatValue();
    }

    public double getDoubleProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new NullPointerException();
        }
        Object currentValue = this.properties.getOrDefault(name, "0");
        if (currentValue instanceof Number) {
            if (!(currentValue instanceof Double) && !(currentValue instanceof Float)) {
                throw new MessageFormatRuntimeException("unsupported conversion");
            }
            return ((Number)currentValue).doubleValue();
        }
        return Utils.runtimeException(() -> Double.parseDouble(currentValue.toString()));
    }

    public String getStringProperty(String name) {
        return Utils.runtimeException(() -> this.properties.getOrDefault(name, "").toString());
    }

    public Object getObjectProperty(String name) {
        return Utils.runtimeException(() -> this.properties.getOrDefault(name, null));
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.correlationID = correlationID;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationID;
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.correlationID = correlationID.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public String getJMSCorrelationID() {
        return this.correlationID == null ? null : new String(this.correlationID, StandardCharsets.UTF_8);
    }

    public JMSProducer setJMSType(String type) {
        this.jmsType = type;
        return this;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.jmsReplyTo = replyTo;
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.jmsReplyTo;
    }
}

