/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarConnection;
import com.datastax.oss.pulsar.jms.PulsarConnectionFactory;
import com.datastax.oss.pulsar.jms.PulsarJMSProducer;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.Utils;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class PulsarJMSContext
implements JMSContext {
    private final PulsarConnection connection;
    final PulsarSession session;
    private boolean autoStart = true;
    private boolean owningConnection;

    public PulsarJMSContext(PulsarConnectionFactory factory, int sessionMode) {
        try {
            this.connection = factory.createConnection();
            this.session = this.connection.createSession(sessionMode);
            this.session.setJms20(true);
            this.connection.setAllowSetClientId(true);
            this.owningConnection = true;
        }
        catch (JMSException err) {
            JMSRuntimeException jms = new JMSRuntimeException("error");
            jms.initCause((Throwable)err);
            throw jms;
        }
    }

    public PulsarJMSContext(PulsarConnection connection, int sessionMode) {
        try {
            this.owningConnection = false;
            this.connection = connection;
            this.session = connection.createSession(sessionMode);
            this.session.setJms20(true);
        }
        catch (JMSException err) {
            JMSRuntimeException jms = new JMSRuntimeException("error");
            jms.initCause((Throwable)err);
            throw jms;
        }
    }

    public JMSContext createContext(int sessionMode) {
        return new PulsarJMSContext(this.connection, sessionMode);
    }

    public JMSProducer createProducer() {
        return new PulsarJMSProducer(this);
    }

    public String getClientID() {
        return Utils.runtimeException(() -> this.connection.getClientID());
    }

    public void setClientID(String clientID) {
        Utils.runtimeException(() -> this.connection.setClientID(clientID));
    }

    public ConnectionMetaData getMetaData() {
        return Utils.runtimeException(() -> this.connection.getMetaData());
    }

    public ExceptionListener getExceptionListener() {
        return Utils.runtimeException(() -> this.connection.getExceptionListener());
    }

    public void setExceptionListener(ExceptionListener listener) {
        Utils.runtimeException(() -> this.connection.setExceptionListener(listener));
    }

    public void start() {
        Utils.runtimeException(() -> this.connection.start());
    }

    public void stop() {
        Utils.runtimeException(() -> {
            Utils.checkNotOnMessageListener(this.session);
            this.connection.stop();
        });
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void close() {
        Utils.runtimeException(() -> {
            try {
                this.session.close();
            }
            finally {
                if (this.owningConnection) {
                    this.connection.close();
                }
            }
        });
    }

    public BytesMessage createBytesMessage() {
        return Utils.runtimeException(this.session::createBytesMessage);
    }

    public MapMessage createMapMessage() {
        return Utils.runtimeException(() -> this.session.createMapMessage());
    }

    public Message createMessage() {
        return Utils.runtimeException(this.session::createMessage);
    }

    public ObjectMessage createObjectMessage() {
        return Utils.runtimeException(() -> this.session.createObjectMessage());
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return Utils.runtimeException(() -> this.session.createObjectMessage(object));
    }

    public StreamMessage createStreamMessage() {
        return Utils.runtimeException(() -> this.session.createStreamMessage());
    }

    public TextMessage createTextMessage() {
        return Utils.runtimeException(() -> this.session.createTextMessage());
    }

    public TextMessage createTextMessage(String text) {
        return Utils.runtimeException(() -> this.session.createTextMessage(text));
    }

    public boolean getTransacted() {
        return Utils.runtimeException(() -> this.session.getTransacted());
    }

    public int getSessionMode() {
        return Utils.runtimeException(this.session::getAcknowledgeMode);
    }

    public void commit() {
        Utils.runtimeException(() -> this.session.commit());
    }

    public void rollback() {
        Utils.runtimeException(() -> this.session.rollback());
    }

    public void recover() {
        Utils.runtimeException(() -> this.session.recover());
    }

    public JMSConsumer createConsumer(Destination destination) {
        this.autoStartIfNeeded();
        return Utils.runtimeException(() -> this.session.createConsumer(destination).asJMSConsumer());
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.autoStartIfNeeded();
        return Utils.runtimeException(() -> this.session.createConsumer(destination, messageSelector).asJMSConsumer());
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.autoStartIfNeeded();
        return Utils.runtimeException(() -> this.session.createConsumer(destination, messageSelector, noLocal).asJMSConsumer());
    }

    public Queue createQueue(String queueName) {
        return Utils.runtimeException(() -> this.session.createQueue(queueName));
    }

    public Topic createTopic(String topicName) {
        return Utils.runtimeException(() -> this.session.createTopic(topicName));
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.autoStartIfNeeded();
        return this.createDurableConsumer(topic, name, null, false);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.autoStartIfNeeded();
        return Utils.runtimeException(() -> this.session.createDurableConsumer(topic, name, messageSelector, noLocal).asJMSConsumer());
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.autoStartIfNeeded();
        return Utils.runtimeException(() -> this.session.createSharedDurableConsumer(topic, name, messageSelector).asJMSConsumer());
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.autoStartIfNeeded();
        return Utils.runtimeException(() -> this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector).asJMSConsumer());
    }

    public QueueBrowser createBrowser(Queue queue) {
        return Utils.runtimeException(() -> this.session.createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return Utils.runtimeException(() -> this.session.createBrowser(queue, messageSelector));
    }

    public TemporaryQueue createTemporaryQueue() {
        return Utils.runtimeException(() -> this.session.createTemporaryQueue());
    }

    public TemporaryTopic createTemporaryTopic() {
        return Utils.runtimeException(() -> this.session.createTemporaryTopic());
    }

    public void unsubscribe(String name) {
        Utils.runtimeException(() -> this.session.unsubscribe(name));
    }

    public void acknowledge() {
        Utils.runtimeException(() -> this.session.acknowledgeAllMessages());
    }

    private void autoStartIfNeeded() {
        if (this.autoStart && !this.connection.isStarted()) {
            Utils.runtimeException(() -> this.connection.start());
        }
    }
}

