/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarConnectionFactory;
import com.datastax.oss.pulsar.jms.PulsarConnectionMetadata;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.PulsarTemporaryDestination;
import com.datastax.oss.pulsar.jms.PulsarTemporaryQueue;
import com.datastax.oss.pulsar.jms.PulsarTemporaryTopic;
import com.datastax.oss.pulsar.jms.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarConnection
implements Connection,
QueueConnection,
TopicConnection {
    private static final Logger log = LoggerFactory.getLogger(PulsarConnection.class);
    private final PulsarConnectionFactory factory;
    private volatile ExceptionListener exceptionListener;
    private final List<PulsarSession> sessions = new CopyOnWriteArrayList<PulsarSession>();
    private final List<PulsarTemporaryDestination> temporaryDestinations = new CopyOnWriteArrayList<PulsarTemporaryDestination>();
    private final String connectionId;
    private volatile boolean closed = false;
    String clientId;
    private volatile boolean allowSetClientId = true;
    private final ReentrantReadWriteLock connectionPausedLock = new ReentrantReadWriteLock();
    private final Condition pausedCondition = this.connectionPausedLock.writeLock().newCondition();
    private volatile boolean paused = true;

    public PulsarConnection(PulsarConnectionFactory factory) throws JMSException {
        this.factory = factory;
        this.clientId = factory.getDefaultClientId();
        if (this.clientId != null) {
            factory.registerClientId(this.clientId);
            this.connectionId = this.clientId + "_" + UUID.randomUUID().toString();
        } else {
            this.connectionId = UUID.randomUUID().toString();
        }
    }

    public PulsarConnectionFactory getFactory() {
        return this.factory;
    }

    public PulsarSession createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkNotClosed();
        this.allowSetClientId = false;
        PulsarSession session = new PulsarSession(transacted ? 0 : acknowledgeMode, this);
        this.sessions.add(session);
        return session;
    }

    void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("This connection is closed");
        }
    }

    public PulsarSession createSession(int sessionMode) throws JMSException {
        return this.createSession(sessionMode == 0, sessionMode);
    }

    public PulsarSession createSession() throws JMSException {
        this.allowSetClientId = false;
        return this.createSession(1);
    }

    public String getClientID() throws JMSException {
        this.checkNotClosed();
        return this.clientId;
    }

    public void setClientID(String clientID) throws JMSException {
        log.info("setClientID {} on {}, factory {}", new Object[]{clientID, this, this.factory});
        this.checkNotClosed();
        if (!this.allowSetClientId) {
            throw new IllegalStateException("Cannot set clientId after performing any other operation");
        }
        if (this.factory.getDefaultClientId() != null) {
            throw new IllegalStateException("ClientId has be administratively configured as " + this.factory.getDefaultClientId() + ", you cannot change it");
        }
        if (clientID == null || clientID.isEmpty()) {
            throw new InvalidClientIDException("Invalid empty clientId");
        }
        if (this.clientId != null) {
            throw new InvalidClientIDException("cannot set again the clientId");
        }
        this.allowSetClientId = false;
        this.factory.registerClientId(clientID);
        this.clientId = clientID;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkNotClosed();
        return PulsarConnectionMetadata.INSTANCE;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkNotClosed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkNotClosed();
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        this.checkNotInSessionMessageListener();
        this.checkNotClosed();
        this.connectionPausedLock.writeLock().lock();
        try {
            this.paused = false;
            this.pausedCondition.signalAll();
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
        finally {
            this.connectionPausedLock.writeLock().unlock();
        }
    }

    public void stop() throws JMSException {
        this.checkNotInSessionMessageListener();
        this.checkNotClosed();
        this.connectionPausedLock.writeLock().lock();
        try {
            this.paused = true;
            this.pausedCondition.signalAll();
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
        finally {
            this.connectionPausedLock.writeLock().unlock();
        }
    }

    private void checkNotInSessionMessageListener() throws JMSException {
        for (PulsarSession session : this.sessions) {
            Utils.checkNotOnMessageListener(session);
        }
    }

    public void close() throws JMSException {
        this.checkNotInSessionMessageListener();
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (PulsarSession session : this.sessions) {
            session.close();
        }
        this.sessions.clear();
        for (PulsarTemporaryDestination temporaryDestination : new ArrayList<PulsarTemporaryDestination>(this.temporaryDestinations)) {
            try {
                temporaryDestination.delete();
            }
            catch (JMSException err) {
                log.error("Cannot delete temporary destination {}", (Object)temporaryDestination.topicName, (Object)err);
            }
        }
        this.temporaryDestinations.clear();
        this.factory.unregisterConnection(this);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        throw new JMSException("not supported");
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        throw new JMSException("not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        throw new JMSException("not supported");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkNotClosed();
        throw new JMSException("not supported");
    }

    public void unregisterSession(PulsarSession session) {
        this.sessions.remove(session);
    }

    public String prependClientId(String subscriptionName, boolean allowUnset) throws JMSException {
        if (this.clientId != null) {
            return this.clientId + "_" + subscriptionName;
        }
        if (allowUnset) {
            return subscriptionName;
        }
        throw new IllegalStateException("ClientID must be set");
    }

    public void setAllowSetClientId(boolean value) {
        this.allowSetClientId = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeInConnectionPausedLock(Utils.SupplierWithException<T> run, int timeoutMillis) throws JMSException {
        boolean executedInTime = true;
        this.connectionPausedLock.readLock().lock();
        try {
            if (this.paused) {
                this.connectionPausedLock.readLock().unlock();
                this.connectionPausedLock.writeLock().lock();
                try {
                    while (this.paused) {
                        if (timeoutMillis > 0) {
                            executedInTime = this.pausedCondition.await(timeoutMillis, TimeUnit.MILLISECONDS);
                            if (executedInTime) continue;
                            break;
                        }
                        this.pausedCondition.await();
                    }
                    this.connectionPausedLock.readLock().lock();
                }
                finally {
                    this.connectionPausedLock.writeLock().unlock();
                }
            }
            if (!executedInTime) {
                T t = null;
                return t;
            }
            T t = run.run();
            return t;
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
        finally {
            this.connectionPausedLock.readLock().unlock();
        }
    }

    public boolean isStarted() {
        this.connectionPausedLock.readLock().lock();
        try {
            boolean bl = !this.paused;
            return bl;
        }
        finally {
            this.connectionPausedLock.readLock().unlock();
        }
    }

    public TemporaryQueue createTemporaryQueue(PulsarSession session) throws JMSException {
        this.checkNotClosed();
        String name = "persistent://" + this.factory.getSystemNamespace() + "/jms-temp-queue-" + UUID.randomUUID();
        try {
            this.factory.getPulsarAdmin().topics().createNonPartitionedTopic(name);
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
        PulsarTemporaryQueue res = new PulsarTemporaryQueue(name, session);
        this.temporaryDestinations.add(res);
        return res;
    }

    public TemporaryTopic createTemporaryTopic(PulsarSession session) throws JMSException {
        this.checkNotClosed();
        String name = "persistent://" + this.factory.getSystemNamespace() + "/jms-temp-topic-" + UUID.randomUUID();
        try {
            this.factory.getPulsarAdmin().topics().createNonPartitionedTopic(name);
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
        PulsarTemporaryTopic res = new PulsarTemporaryTopic(name, session);
        this.temporaryDestinations.add(res);
        return res;
    }

    public QueueSession createQueueSession(boolean b, int i) throws JMSException {
        return this.createSession(b, i).emulateLegacySession(true, false);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkNotClosed();
        throw new JMSException("Not implemented");
    }

    public TopicSession createTopicSession(boolean b, int i) throws JMSException {
        return this.createSession(b, i).emulateLegacySession(false, true);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        throw new JMSException("Not implemented");
    }

    void removeTemporaryDestination(PulsarTemporaryDestination pulsarTemporaryDestination) {
        this.temporaryDestinations.remove(pulsarTemporaryDestination);
    }

    public String getConnectionId() {
        return this.connectionId;
    }
}

