/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import java.nio.ByteBuffer;

public class AuthResponse
extends Message {
    public final ByteBuffer token;

    public AuthResponse(ByteBuffer token) {
        super(false, 15);
        this.token = token;
    }

    public String toString() {
        return "AUTH_RESPONSE";
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(15, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            AuthResponse authResponse = (AuthResponse)message;
            encoder.writeBytes(authResponse.token, dest);
        }

        @Override
        public int encodedSize(Message message) {
            AuthResponse authResponse = (AuthResponse)message;
            return PrimitiveSizes.sizeOfBytes(authResponse.token);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            ByteBuffer token = decoder.readBytes(source);
            return new AuthResponse(token);
        }
    }
}

