/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.simulacron;

import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.server.BoundTopic;
import com.datastax.oss.simulacron.server.listener.QueryListener;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;

public class QueryCounter {
    private final long beforeTimeout;
    private final TimeUnit beforeUnit;
    private final AtomicInteger totalCount = new AtomicInteger(0);
    private final ConcurrentHashMap<Integer, Integer> countMap = new ConcurrentHashMap();

    private QueryCounter(BoundTopic<?, ?> topic, NotificationMode notificationMode, Predicate<QueryLog> queryLogFilter, long beforeTimeout, TimeUnit beforeUnit) {
        this.beforeTimeout = beforeTimeout;
        this.beforeUnit = beforeUnit;
        QueryListener listener = (boundNode, queryLog) -> {
            this.totalCount.incrementAndGet();
            this.countMap.merge(boundNode.getId().intValue(), 1, Integer::sum);
        };
        topic.registerQueryListener(listener, notificationMode == NotificationMode.AFTER_PROCESSING, queryLogFilter);
    }

    public static QueryCounterBuilder builder(BoundTopic<?, ?> topic) {
        return new QueryCounterBuilder(topic);
    }

    public void clearCounts() {
        this.totalCount.set(0);
        this.countMap.clear();
    }

    public void assertTotalCount(int expected) {
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(this.beforeTimeout, this.beforeUnit).untilAsserted(() -> Assertions.assertThat((int)this.totalCount.get()).isEqualTo(expected));
    }

    public void assertNodeCounts(int ... counts) {
        HashMap<Integer, Integer> expectedCounts = new HashMap<Integer, Integer>();
        for (int id = 0; id < counts.length; ++id) {
            int count = counts[id];
            if (count <= 0) continue;
            expectedCounts.put(id, counts[id]);
        }
        Awaitility.await().pollInterval(10L, TimeUnit.MILLISECONDS).atMost(this.beforeTimeout, this.beforeUnit).untilAsserted(() -> {
            MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat(this.countMap).containsAllEntriesOf(expectedCounts);
        });
    }

    public static class QueryCounterBuilder {
        private static Predicate<QueryLog> DEFAULT_FILTER = q -> !q.getQuery().isEmpty();
        private Predicate<QueryLog> queryLogFilter = DEFAULT_FILTER;
        private BoundTopic<?, ?> topic;
        private NotificationMode notificationMode = NotificationMode.BEFORE_PROCESSING;
        private long beforeTimeout = 1L;
        private TimeUnit beforeUnit = TimeUnit.SECONDS;

        private QueryCounterBuilder(BoundTopic<?, ?> topic) {
            this.topic = topic;
        }

        public QueryCounterBuilder withFilter(Predicate<QueryLog> queryLogFilter) {
            this.queryLogFilter = queryLogFilter;
            return this;
        }

        public QueryCounterBuilder withNotification(NotificationMode notificationMode) {
            this.notificationMode = notificationMode;
            return this;
        }

        public QueryCounterBuilder before(long timeout, TimeUnit unit) {
            this.beforeTimeout = timeout;
            this.beforeUnit = unit;
            return this;
        }

        public QueryCounter build() {
            return new QueryCounter(this.topic, this.notificationMode, this.queryLogFilter, this.beforeTimeout, this.beforeUnit);
        }
    }

    public static enum NotificationMode {
        BEFORE_PROCESSING,
        AFTER_PROCESSING;

    }
}

