/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.Query;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.NullSavingStrategyValidation;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class DaoQueryMethodGenerator
extends DaoMethodGenerator {
    private final String queryString;
    private final NullSavingStrategyValidation nullSavingStrategyValidation;

    public DaoQueryMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, processedType, enclosingClass, context);
        this.queryString = methodElement.getAnnotation(Query.class).value();
        this.nullSavingStrategyValidation = new NullSavingStrategyValidation(context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DefaultDaoReturnTypeKind value : DefaultDaoReturnTypeKind.values()) {
            if (value == DefaultDaoReturnTypeKind.UNSUPPORTED) continue;
            builder.add((Object)value);
        }
        return builder.build();
    }

    @Override
    public Optional<MethodSpec> generate() {
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Query.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        TypeElement entityElement = returnType.getEntityElement();
        String helperFieldName = entityElement == null ? null : this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generatePrepareRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName));
        CodeBlock.Builder methodBodyBuilder = CodeBlock.builder();
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, this.methodElement.getParameters().size() - 1);
        }
        methodBodyBuilder.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        NullSavingStrategy nullSavingStrategy = this.nullSavingStrategyValidation.getNullSavingStrategy(Query.class, Query::nullSavingStrategy, this.methodElement, this.enclosingClass);
        methodBodyBuilder.addStatement("$1T nullSavingStrategy = $1T.$2L", new Object[]{NullSavingStrategy.class, nullSavingStrategy});
        this.populateBuilderWithStatementAttributes(methodBodyBuilder, this.methodElement);
        this.populateBuilderWithFunction(methodBodyBuilder, boundStatementFunction);
        if (this.validateCqlNamesPresent(parameters)) {
            GeneratedCodePatterns.bindParameters(parameters, methodBodyBuilder, this.enclosingClass, this.context, true);
            methodBodyBuilder.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
            returnType.getKind().addExecuteStatement(methodBodyBuilder, helperFieldName);
            CodeBlock methodBody = returnType.getKind().wrapWithErrorHandling(methodBodyBuilder.build());
            return Optional.of(GeneratedCodePatterns.override(this.methodElement, this.typeParameters).addCode(methodBody).build());
        }
        return Optional.empty();
    }

    private void generatePrepareRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName) {
        methodBuilder.addStatement("$T $L = replaceKeyspaceAndTablePlaceholders($S, context, $L)", new Object[]{SimpleStatement.class, requestName, this.queryString, helperFieldName});
    }
}

