/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.InvalidKeyspaceException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ConnectionInitException;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerRequest;
import com.datastax.oss.driver.internal.core.channel.ClusterNameMismatchException;
import com.datastax.oss.driver.internal.core.channel.ConnectInitHandler;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.channel.HeartbeatHandler;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.util.ProtocolUtils;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.AuthResponse;
import com.datastax.oss.protocol.internal.request.Options;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.request.Register;
import com.datastax.oss.protocol.internal.request.Startup;
import com.datastax.oss.protocol.internal.response.AuthChallenge;
import com.datastax.oss.protocol.internal.response.AuthSuccess;
import com.datastax.oss.protocol.internal.response.Authenticate;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Ready;
import com.datastax.oss.protocol.internal.response.Supported;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.SetKeyspace;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ProtocolInitHandler
extends ConnectInitHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolInitHandler.class);
    private static final Query CLUSTER_NAME_QUERY = new Query("SELECT cluster_name FROM system.local");
    private final InternalDriverContext context;
    private final long timeoutMillis;
    private final ProtocolVersion initialProtocolVersion;
    private final DriverChannelOptions options;
    private final String expectedClusterName;
    private final EndPoint endPoint;
    private final HeartbeatHandler heartbeatHandler;
    private String logPrefix;
    private ChannelHandlerContext ctx;
    private boolean querySupportedOptions;

    ProtocolInitHandler(InternalDriverContext context, ProtocolVersion protocolVersion, String expectedClusterName, EndPoint endPoint, DriverChannelOptions options, HeartbeatHandler heartbeatHandler, boolean querySupportedOptions) {
        this.context = context;
        this.endPoint = endPoint;
        DriverExecutionProfile defaultConfig = context.getConfig().getDefaultProfile();
        this.timeoutMillis = defaultConfig.getDuration(DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT).toMillis();
        this.initialProtocolVersion = protocolVersion;
        this.expectedClusterName = expectedClusterName;
        this.options = options;
        this.heartbeatHandler = heartbeatHandler;
        this.querySupportedOptions = querySupportedOptions;
        this.logPrefix = options.ownerLogPrefix + "|connecting...";
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        String channelId = ctx.channel().toString();
        this.logPrefix = this.options.ownerLogPrefix + "|" + channelId.substring(1, channelId.length() - 1);
    }

    @Override
    protected void onRealConnect(ChannelHandlerContext ctx) {
        LOG.debug("[{}] Starting channel initialization", (Object)this.logPrefix);
        this.ctx = ctx;
        new InitRequest(ctx).send();
    }

    @Override
    protected boolean setConnectSuccess() {
        boolean result = super.setConnectSuccess();
        if (result) {
            this.ctx.pipeline().addBefore("inflight", "heartbeat", (ChannelHandler)this.heartbeatHandler);
        }
        return result;
    }

    private String getString(List<ByteBuffer> row, int i) {
        return TypeCodecs.TEXT.decode(row.get(i), DefaultProtocolVersion.DEFAULT);
    }

    private class InitRequest
    extends ChannelHandlerRequest {
        private Step step;
        private int stepNumber;
        private Message request;
        private Authenticator authenticator;
        private ByteBuffer authResponseToken;

        InitRequest(ChannelHandlerContext ctx) {
            super(ctx, ProtocolInitHandler.this.timeoutMillis);
            this.stepNumber = 0;
            this.step = ProtocolInitHandler.this.querySupportedOptions ? Step.OPTIONS : Step.STARTUP;
        }

        @Override
        String describe() {
            return String.format("[%s] Protocol initialization request, step %d (%s)", ProtocolInitHandler.this.logPrefix, this.stepNumber, this.request);
        }

        @Override
        Message getRequest() {
            switch (this.step) {
                case OPTIONS: {
                    this.request = Options.INSTANCE;
                    return this.request;
                }
                case STARTUP: {
                    this.request = new Startup(ProtocolInitHandler.this.context.getStartupOptions());
                    return this.request;
                }
                case GET_CLUSTER_NAME: {
                    this.request = CLUSTER_NAME_QUERY;
                    return this.request;
                }
                case SET_KEYSPACE: {
                    this.request = new Query("USE " + ((ProtocolInitHandler)ProtocolInitHandler.this).options.keyspace.asCql(false));
                    return this.request;
                }
                case AUTH_RESPONSE: {
                    this.request = new AuthResponse(this.authResponseToken);
                    return this.request;
                }
                case REGISTER: {
                    this.request = new Register(((ProtocolInitHandler)ProtocolInitHandler.this).options.eventTypes);
                    return this.request;
                }
            }
            throw new AssertionError((Object)("unhandled step: " + (Object)((Object)this.step)));
        }

        @Override
        void send() {
            ++this.stepNumber;
            super.send();
        }

        @Override
        void onResponse(Message response) {
            LOG.debug("[{}] step {} received response opcode={}", new Object[]{ProtocolInitHandler.this.logPrefix, this.step, ProtocolUtils.opcodeString(response.opcode)});
            try {
                if (this.step == Step.OPTIONS && response instanceof Supported) {
                    this.channel.attr(DriverChannel.OPTIONS_KEY).set((Object)((Supported)response).options);
                    this.step = Step.STARTUP;
                    this.send();
                } else if (this.step == Step.STARTUP && response instanceof Ready) {
                    ProtocolInitHandler.this.context.getAuthProvider().ifPresent(provider -> provider.onMissingChallenge(ProtocolInitHandler.this.endPoint));
                    this.step = Step.GET_CLUSTER_NAME;
                    this.send();
                } else if (this.step == Step.STARTUP && response instanceof Authenticate) {
                    Authenticate authenticate = (Authenticate)response;
                    this.authenticator = this.buildAuthenticator(ProtocolInitHandler.this.endPoint, authenticate.authenticator);
                    this.authenticator.initialResponse().whenCompleteAsync((token, error) -> {
                        if (error != null) {
                            this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, String.format("Authenticator.initialResponse(): stage completed exceptionally (%s)", error), (Throwable)error));
                        } else {
                            this.step = Step.AUTH_RESPONSE;
                            this.authResponseToken = token;
                            this.send();
                        }
                    }, (Executor)this.channel.eventLoop()).exceptionally(UncaughtExceptions::log);
                } else if (this.step == Step.AUTH_RESPONSE && response instanceof AuthChallenge) {
                    ByteBuffer challenge = ((AuthChallenge)response).token;
                    this.authenticator.evaluateChallenge(challenge).whenCompleteAsync((token, error) -> {
                        if (error != null) {
                            this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, String.format("Authenticator.evaluateChallenge(): stage completed exceptionally (%s)", error), (Throwable)error));
                        } else {
                            this.step = Step.AUTH_RESPONSE;
                            this.authResponseToken = token;
                            this.send();
                        }
                    }, (Executor)this.channel.eventLoop()).exceptionally(UncaughtExceptions::log);
                } else if (this.step == Step.AUTH_RESPONSE && response instanceof AuthSuccess) {
                    ByteBuffer token2 = ((AuthSuccess)response).token;
                    this.authenticator.onAuthenticationSuccess(token2).whenCompleteAsync((ignored, error) -> {
                        if (error != null) {
                            this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, String.format("Authenticator.onAuthenticationSuccess(): stage completed exceptionally (%s)", error), (Throwable)error));
                        } else {
                            this.step = Step.GET_CLUSTER_NAME;
                            this.send();
                        }
                    }, (Executor)this.channel.eventLoop()).exceptionally(UncaughtExceptions::log);
                } else if (this.step == Step.AUTH_RESPONSE && response instanceof Error && ((Error)response).code == 256) {
                    this.fail(new AuthenticationException(ProtocolInitHandler.this.endPoint, String.format("server replied with '%s' to AuthResponse request", ((Error)response).message)));
                } else if (this.step == Step.GET_CLUSTER_NAME && response instanceof Rows) {
                    Rows rows = (Rows)response;
                    List row = Objects.requireNonNull((List)rows.getData().poll());
                    String actualClusterName = ProtocolInitHandler.this.getString(row, 0);
                    if (ProtocolInitHandler.this.expectedClusterName != null && !ProtocolInitHandler.this.expectedClusterName.equals(actualClusterName)) {
                        this.fail(new ClusterNameMismatchException(ProtocolInitHandler.this.endPoint, actualClusterName, ProtocolInitHandler.this.expectedClusterName));
                    } else {
                        if (ProtocolInitHandler.this.expectedClusterName == null) {
                            this.channel.attr(DriverChannel.CLUSTER_NAME_KEY).set((Object)actualClusterName);
                        }
                        if (((ProtocolInitHandler)ProtocolInitHandler.this).options.keyspace != null) {
                            this.step = Step.SET_KEYSPACE;
                            this.send();
                        } else if (!((ProtocolInitHandler)ProtocolInitHandler.this).options.eventTypes.isEmpty()) {
                            this.step = Step.REGISTER;
                            this.send();
                        } else {
                            ProtocolInitHandler.this.setConnectSuccess();
                        }
                    }
                } else if (this.step == Step.SET_KEYSPACE && response instanceof SetKeyspace) {
                    if (!((ProtocolInitHandler)ProtocolInitHandler.this).options.eventTypes.isEmpty()) {
                        this.step = Step.REGISTER;
                        this.send();
                    } else {
                        ProtocolInitHandler.this.setConnectSuccess();
                    }
                } else if (this.step == Step.REGISTER && response instanceof Ready) {
                    ProtocolInitHandler.this.setConnectSuccess();
                } else if (response instanceof Error) {
                    boolean serverOrProtocolError;
                    Error error2 = (Error)response;
                    boolean firstRequest = this.step == Step.OPTIONS && ProtocolInitHandler.this.querySupportedOptions || this.step == Step.STARTUP;
                    boolean bl = serverOrProtocolError = error2.code == 10 || error2.code == 0;
                    if (firstRequest && serverOrProtocolError && error2.message.contains("Invalid or unsupported protocol version")) {
                        this.fail(UnsupportedProtocolVersionException.forSingleAttempt(ProtocolInitHandler.this.endPoint, ProtocolInitHandler.this.initialProtocolVersion));
                    } else if (this.step == Step.SET_KEYSPACE && error2.code == 8704) {
                        this.fail(new InvalidKeyspaceException(error2.message));
                    } else {
                        this.failOnUnexpected((Message)error2);
                    }
                } else {
                    this.failOnUnexpected(response);
                }
            }
            catch (AuthenticationException e) {
                this.fail(e);
            }
            catch (Throwable t) {
                this.fail(String.format("%s: unexpected exception (%s)", this.describe(), t), t);
            }
        }

        @Override
        void fail(String message, Throwable cause) {
            Throwable finalException = message == null ? cause : new ConnectionInitException(message, cause);
            ProtocolInitHandler.this.setConnectFailure(finalException);
        }

        private Authenticator buildAuthenticator(EndPoint endPoint, String authenticator) {
            return ProtocolInitHandler.this.context.getAuthProvider().map(p -> p.newAuthenticator(endPoint, authenticator)).orElseThrow(() -> new AuthenticationException(endPoint, String.format("Node %s requires authentication (%s), but no authenticator configured", endPoint, authenticator)));
        }

        public String toString() {
            return "init query " + (Object)((Object)this.step);
        }
    }

    private static enum Step {
        OPTIONS,
        STARTUP,
        GET_CLUSTER_NAME,
        SET_KEYSPACE,
        AUTH_RESPONSE,
        REGISTER;

    }
}

