/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetrics;
import com.datastax.oss.driver.internal.core.metrics.DropwizardNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.DropwizardSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DropwizardMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardMetricsFactory.class);
    private final String logPrefix;
    private final InternalDriverContext context;
    private final Set<NodeMetric> enabledNodeMetrics;
    private final MetricRegistry registry;
    @Nullable
    private final Metrics metrics;
    private final SessionMetricUpdater sessionUpdater;

    public DropwizardMetricsFactory(InternalDriverContext context) {
        this.logPrefix = context.getSessionName();
        this.context = context;
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set<SessionMetric> enabledSessionMetrics = this.parseSessionMetricPaths(config.getStringList(DefaultDriverOption.METRICS_SESSION_ENABLED));
        this.enabledNodeMetrics = this.parseNodeMetricPaths(config.getStringList(DefaultDriverOption.METRICS_NODE_ENABLED));
        if (enabledSessionMetrics.isEmpty() && this.enabledNodeMetrics.isEmpty()) {
            LOG.debug("[{}] All metrics are disabled, Session.getMetrics will be empty", (Object)this.logPrefix);
            this.registry = null;
            this.sessionUpdater = NoopSessionMetricUpdater.INSTANCE;
            this.metrics = null;
        } else {
            this.registry = new MetricRegistry();
            DropwizardSessionMetricUpdater dropwizardSessionUpdater = new DropwizardSessionMetricUpdater(enabledSessionMetrics, this.registry, context);
            this.sessionUpdater = dropwizardSessionUpdater;
            this.metrics = new DefaultMetrics(this.registry, dropwizardSessionUpdater);
        }
    }

    @Override
    public Optional<Metrics> getMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    @Override
    public SessionMetricUpdater getSessionUpdater() {
        return this.sessionUpdater;
    }

    @Override
    public NodeMetricUpdater newNodeUpdater(Node node) {
        return this.registry == null ? NoopNodeMetricUpdater.INSTANCE : new DropwizardNodeMetricUpdater(node, this.enabledNodeMetrics, this.registry, this.context);
    }

    protected Set<SessionMetric> parseSessionMetricPaths(List<String> paths) {
        HashSet<Enum> result = new HashSet<Enum>();
        for (String path : paths) {
            try {
                result.add(DefaultSessionMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add(DseSessionMetric.fromPath(path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown session metric {}, skipping", (Object)this.logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected Set<NodeMetric> parseNodeMetricPaths(List<String> paths) {
        EnumSet<DefaultNodeMetric> result = EnumSet.noneOf(DefaultNodeMetric.class);
        for (String path : paths) {
            try {
                result.add(DefaultNodeMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("[{}] Unknown node metric {}, skipping", (Object)this.logPrefix, (Object)path);
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

