/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.Bindable;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.StatementBuilder;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class BoundStatementBuilder
extends StatementBuilder<BoundStatementBuilder, BoundStatement>
implements Bindable<BoundStatementBuilder> {
    @NonNull
    private final PreparedStatement preparedStatement;
    @NonNull
    private final ColumnDefinitions variableDefinitions;
    @NonNull
    private final ByteBuffer[] values;
    @NonNull
    private final CodecRegistry codecRegistry;
    @NonNull
    private final ProtocolVersion protocolVersion;

    public BoundStatementBuilder(@NonNull PreparedStatement preparedStatement, @NonNull ColumnDefinitions variableDefinitions, @NonNull ByteBuffer[] values, @Nullable String executionProfileName, @Nullable DriverExecutionProfile executionProfile, @Nullable CqlIdentifier routingKeyspace, @Nullable ByteBuffer routingKey, @Nullable Token routingToken, @NonNull Map<String, ByteBuffer> customPayload, @Nullable Boolean idempotent, boolean tracing, long timestamp, @Nullable ByteBuffer pagingState, int pageSize, @Nullable ConsistencyLevel consistencyLevel, @Nullable ConsistencyLevel serialConsistencyLevel, @Nullable Duration timeout, @NonNull CodecRegistry codecRegistry, @NonNull ProtocolVersion protocolVersion) {
        this.preparedStatement = preparedStatement;
        this.variableDefinitions = variableDefinitions;
        this.values = values;
        this.executionProfileName = executionProfileName;
        this.executionProfile = executionProfile;
        this.routingKeyspace = routingKeyspace;
        this.routingKey = routingKey;
        this.routingToken = routingToken;
        for (Map.Entry<String, ByteBuffer> entry : customPayload.entrySet()) {
            this.addCustomPayload(entry.getKey(), entry.getValue());
        }
        this.idempotent = idempotent;
        this.tracing = tracing;
        this.timestamp = timestamp;
        this.pagingState = pagingState;
        this.pageSize = pageSize;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.timeout = timeout;
        this.codecRegistry = codecRegistry;
        this.protocolVersion = protocolVersion;
    }

    public BoundStatementBuilder(@NonNull BoundStatement template) {
        super(template);
        this.preparedStatement = template.getPreparedStatement();
        this.variableDefinitions = template.getPreparedStatement().getVariableDefinitions();
        this.values = template.getValues().toArray(new ByteBuffer[this.variableDefinitions.size()]);
        this.codecRegistry = template.codecRegistry();
        this.protocolVersion = template.protocolVersion();
        this.node = template.getNode();
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        int indexOf = this.variableDefinitions.firstIndexOf(id);
        if (indexOf == -1) {
            throw new IllegalArgumentException(id + " is not a variable in this bound statement");
        }
        return indexOf;
    }

    @Override
    public int firstIndexOf(@NonNull String name) {
        int indexOf = this.variableDefinitions.firstIndexOf(name);
        if (indexOf == -1) {
            throw new IllegalArgumentException(name + " is not a variable in this bound statement");
        }
        return indexOf;
    }

    @Override
    @NonNull
    public BoundStatementBuilder setBytesUnsafe(int i, ByteBuffer v) {
        this.values[i] = v;
        return this;
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        return this.values[i];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    @NonNull
    public DataType getType(int i) {
        return this.variableDefinitions.get(i).getType();
    }

    @Override
    @NonNull
    public CodecRegistry codecRegistry() {
        return this.codecRegistry;
    }

    @Override
    @NonNull
    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    @NonNull
    public BoundStatement build() {
        return new DefaultBoundStatement(this.preparedStatement, this.variableDefinitions, this.values, this.executionProfileName, this.executionProfile, this.routingKeyspace, this.routingKey, this.routingToken, this.buildCustomPayload(), this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.codecRegistry, this.protocolVersion, this.node);
    }
}

