/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.api.core.graph.predicates.Geo;
import com.datastax.dse.driver.api.core.graph.predicates.Search;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.dse.driver.internal.core.data.geometry.Distance;
import com.datastax.dse.driver.internal.core.graph.EditDistance;
import com.datastax.dse.driver.internal.core.graph.GeoPredicate;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.dse.driver.internal.core.graph.SearchPredicate;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class GraphSON3SerdeTP {

    public static class DriverObjectsModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        public DriverObjectsModule() {
            super("datastax-driver-module");
            this.addSerializer(ObjectGraphNode.class, (JsonSerializer)new ObjectGraphNodeGraphSON3Serializer());
        }

        static final class ObjectGraphNodeGraphSON3Serializer
        extends StdSerializer<ObjectGraphNode> {
            private static final long serialVersionUID = 1L;

            protected ObjectGraphNodeGraphSON3Serializer() {
                super(ObjectGraphNode.class);
            }

            public void serialize(ObjectGraphNode objectGraphNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeObject(objectGraphNode.as(Object.class));
            }

            public void serializeWithType(ObjectGraphNode objectGraphNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
                this.serialize(objectGraphNode, jsonGenerator, serializerProvider);
            }
        }
    }

    public static class DseGraphModule
    extends TinkerPopJacksonModule {
        private static final long serialVersionUID = 1L;

        public DseGraphModule() {
            super("dse-driver-2.0");
            this.addSerializer(DefaultPoint.class, (JsonSerializer)new PointGeometrySerializer());
            this.addSerializer(DefaultLineString.class, (JsonSerializer)new LineStringGeometrySerializer());
            this.addSerializer(DefaultPolygon.class, (JsonSerializer)new PolygonGeometrySerializer());
            this.addSerializer(Distance.class, (JsonSerializer)new DistanceGeometrySerializer());
            this.addSerializer(P.class, (JsonSerializer)new DsePJacksonSerializer());
            this.addSerializer(EditDistance.class, (JsonSerializer)new EditDistanceSerializer());
            this.addDeserializer(DefaultLineString.class, (JsonDeserializer)new LineStringGeometryDeserializer());
            this.addDeserializer(DefaultPoint.class, (JsonDeserializer)new PointGeometryDeserializer());
            this.addDeserializer(DefaultPolygon.class, (JsonDeserializer)new PolygonGeometryDeserializer());
            this.addDeserializer(Distance.class, (JsonDeserializer)new DistanceGeometryDeserializer());
            this.addDeserializer(P.class, (JsonDeserializer)new DsePJacksonDeserializer());
        }

        public Map<Class, String> getTypeDefinitions() {
            HashMap<Class, String> definitions = new HashMap<Class, String>();
            definitions.put(DefaultLineString.class, "LineString");
            definitions.put(DefaultPoint.class, "Point");
            definitions.put(DefaultPolygon.class, "Polygon");
            definitions.put(byte[].class, "Blob");
            definitions.put(Distance.class, "Distance");
            definitions.put(P.class, "P");
            return definitions;
        }

        public String getTypeNamespace() {
            return "dse";
        }

        public static class EditDistanceSerializer
        extends StdSerializer<EditDistance> {
            private static final long serialVersionUID = 1L;

            EditDistanceSerializer() {
                super(EditDistance.class);
            }

            public void serialize(EditDistance editDistance, JsonGenerator generator, SerializerProvider provider) throws IOException {
                generator.writeObject((Object)ImmutableMap.of((Object)"query", (Object)editDistance.query, (Object)"distance", (Object)editDistance.distance));
            }

            public void serializeWithType(EditDistance editDistance, JsonGenerator generator, SerializerProvider provider, TypeSerializer serializer) throws IOException {
                this.serialize(editDistance, generator, provider);
            }
        }

        static final class DsePJacksonDeserializer
        extends AbstractObjectDeserializer<P> {
            private static final long serialVersionUID = 1L;

            DsePJacksonDeserializer() {
                super(P.class);
            }

            public P createObject(Map<String, Object> data) {
                String predicate = (String)data.get("predicate");
                String predicateType = (String)data.get("predicateType");
                Object value = data.get("value");
                if (predicate.equals("and") || predicate.equals("or")) {
                    return predicate.equals("and") ? new AndP((List)value) : new OrP((List)value);
                }
                try {
                    if (value instanceof Collection) {
                        if (predicate.equals("between")) {
                            return P.between(((List)value).get(0), ((List)value).get(1));
                        }
                        if (predicateType.equals(P.class.getSimpleName()) && predicate.equals("inside")) {
                            return P.between(((List)value).get(0), ((List)value).get(1));
                        }
                        if (predicate.equals("outside")) {
                            return P.outside(((List)value).get(0), ((List)value).get(1));
                        }
                        if (predicate.equals("within")) {
                            return P.within((Collection)((Collection)value));
                        }
                        if (predicate.equals("without")) {
                            return P.without((Collection)((Collection)value));
                        }
                        return (P)P.class.getMethod(predicate, Collection.class).invoke(null, (Collection)value);
                    }
                    if (predicate.equals(SearchPredicate.prefix.name())) {
                        return Search.prefix((String)value);
                    }
                    if (predicate.equals(SearchPredicate.tokenPrefix.name())) {
                        return Search.tokenPrefix((String)value);
                    }
                    if (predicate.equals(SearchPredicate.regex.name())) {
                        return Search.regex((String)value);
                    }
                    if (predicate.equals(SearchPredicate.tokenRegex.name())) {
                        return Search.tokenRegex((String)value);
                    }
                    if (predicate.equals(SearchPredicate.token.name())) {
                        return Search.token((String)value);
                    }
                    if (predicate.equals(SearchPredicate.fuzzy.name())) {
                        Map arguments = (Map)value;
                        return Search.fuzzy((String)arguments.get("query"), (Integer)arguments.get("distance"));
                    }
                    if (predicate.equals(SearchPredicate.tokenFuzzy.name())) {
                        Map arguments = (Map)value;
                        return Search.tokenFuzzy((String)arguments.get("query"), (Integer)arguments.get("distance"));
                    }
                    if (predicate.equals(SearchPredicate.phrase.name())) {
                        Map arguments = (Map)value;
                        return Search.phrase((String)arguments.get("query"), (Integer)arguments.get("distance"));
                    }
                    if (predicateType.equals(Geo.class.getSimpleName()) && predicate.equals(GeoPredicate.inside.name())) {
                        return Geo.inside(((Distance)value).getCenter(), ((Distance)value).getRadius(), Geo.Unit.DEGREES);
                    }
                    if (predicateType.equals(Geo.class.getSimpleName()) && predicate.equals(GeoPredicate.insideCartesian.name())) {
                        return Geo.inside(((Distance)value).getCenter(), ((Distance)value).getRadius());
                    }
                    return (P)P.class.getMethod(predicate, Object.class).invoke(null, value);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }

        static final class DsePJacksonSerializer
        extends StdScalarSerializer<P> {
            private static final long serialVersionUID = 1L;

            DsePJacksonSerializer() {
                super(P.class);
            }

            public void serialize(P p, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("predicateType", this.getPredicateType(p));
                jsonGenerator.writeStringField("predicate", p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
                if (p instanceof ConnectiveP) {
                    jsonGenerator.writeArrayFieldStart("value");
                    for (P predicate : ((ConnectiveP)p).getPredicates()) {
                        jsonGenerator.writeObject((Object)predicate);
                    }
                    jsonGenerator.writeEndArray();
                } else if (p.getValue() instanceof Collection) {
                    jsonGenerator.writeArrayFieldStart("value");
                    for (Object object : (Collection)p.getValue()) {
                        jsonGenerator.writeObject(object);
                    }
                    jsonGenerator.writeEndArray();
                } else {
                    jsonGenerator.writeObjectField("value", p.getValue());
                }
                jsonGenerator.writeEndObject();
            }

            private String getPredicateType(P p) {
                if (p.getBiPredicate() instanceof SearchPredicate) {
                    return Search.class.getSimpleName();
                }
                if (p.getBiPredicate() instanceof GeoPredicate) {
                    return Geo.class.getSimpleName();
                }
                return P.class.getSimpleName();
            }
        }

        public static class DistanceGeometryDeserializer
        extends AbstractGeometryJacksonDeserializer<Distance> {
            private static final long serialVersionUID = 1L;

            DistanceGeometryDeserializer() {
                super(Distance.class);
            }

            @Override
            public Distance parse(String val) {
                return Distance.fromWellKnownText(val);
            }
        }

        public static class DistanceGeometrySerializer
        extends AbstractGeometryJacksonSerializer<Distance> {
            private static final long serialVersionUID = 1L;

            DistanceGeometrySerializer() {
                super(Distance.class);
            }
        }

        public static class PointGeometryDeserializer
        extends AbstractGeometryJacksonDeserializer<DefaultPoint> {
            private static final long serialVersionUID = 1L;

            PointGeometryDeserializer() {
                super(DefaultPoint.class);
            }

            @Override
            public DefaultPoint parse(String val) {
                return (DefaultPoint)Point.fromWellKnownText(val);
            }
        }

        public static class PointGeometrySerializer
        extends AbstractGeometryJacksonSerializer<Point> {
            private static final long serialVersionUID = 1L;

            PointGeometrySerializer() {
                super(Point.class);
            }
        }

        public static class PolygonGeometryDeserializer
        extends AbstractGeometryJacksonDeserializer<DefaultPolygon> {
            private static final long serialVersionUID = 1L;

            PolygonGeometryDeserializer() {
                super(DefaultPolygon.class);
            }

            @Override
            public DefaultPolygon parse(String val) {
                return (DefaultPolygon)Polygon.fromWellKnownText(val);
            }
        }

        public static class PolygonGeometrySerializer
        extends AbstractGeometryJacksonSerializer<Polygon> {
            private static final long serialVersionUID = 1L;

            PolygonGeometrySerializer() {
                super(Polygon.class);
            }
        }

        public static class LineStringGeometryDeserializer
        extends AbstractGeometryJacksonDeserializer<DefaultLineString> {
            private static final long serialVersionUID = 1L;

            LineStringGeometryDeserializer() {
                super(DefaultLineString.class);
            }

            @Override
            public DefaultLineString parse(String val) {
                return (DefaultLineString)LineString.fromWellKnownText(val);
            }
        }

        public static class LineStringGeometrySerializer
        extends AbstractGeometryJacksonSerializer<LineString> {
            private static final long serialVersionUID = 1L;

            LineStringGeometrySerializer() {
                super(LineString.class);
            }
        }

        static abstract class AbstractGeometryJacksonSerializer<T extends Geometry>
        extends StdScalarSerializer<T> {
            private static final long serialVersionUID = 1L;

            AbstractGeometryJacksonSerializer(Class<T> clazz) {
                super(clazz);
            }

            public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
                gen.writeString(value.asWellKnownText());
            }
        }

        static abstract class AbstractGeometryJacksonDeserializer<T extends Geometry>
        extends StdDeserializer<T> {
            private static final long serialVersionUID = 1L;

            AbstractGeometryJacksonDeserializer(Class<T> clazz) {
                super(clazz);
            }

            public abstract T parse(String var1);

            public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return this.parse(jsonParser.getText());
            }
        }
    }
}

