/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import java.nio.ByteBuffer;

public class PolygonSerializer extends GeometrySerializer<Polygon> {
  @Override
  public String getTypeName() {
    return GraphBinaryModule.GRAPH_BINARY_POLYGON_TYPE_NAME;
  }

  @Override
  public Polygon fromWellKnownBinary(ByteBuffer buffer) {
    return Polygon.fromWellKnownBinary(buffer);
  }
}
