/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.internal.core.util.Reflection;
import com.datastax.oss.driver.shaded.guava.common.base.Supplier;
import com.datastax.oss.driver.shaded.guava.common.base.Suppliers;

public enum DependencyCheck {
    SNAPPY("org.xerial.snappy.Snappy"),
    LZ4("net.jpountz.lz4.LZ4Compressor"),
    ESRI("com.esri.core.geometry.ogc.OGCGeometry"),
    TINKERPOP("org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal", "org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3d0"),
    REACTIVE_STREAMS("org.reactivestreams.Publisher"),
    JACKSON("com.fasterxml.jackson.core.JsonParser", "com.fasterxml.jackson.databind.ObjectMapper"),
    DROPWIZARD("com.codahale.metrics.MetricRegistry");

    private final Supplier<Boolean> present = Suppliers.memoize(() -> {
        for (String classNameToTest : classNamesToTest) {
            if (Reflection.loadClass(null, classNameToTest) != null) continue;
            return false;
        }
        return true;
    });

    private DependencyCheck(String ... classNamesToTest) {
    }

    public boolean isPresent() {
        return (Boolean)this.present.get();
    }
}

