/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.connection.ClosedConnectionException;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.retry.ConsistencyDowngradingRetryVerdict;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyDowngradingRetryPolicy
implements RetryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ConsistencyDowngradingRetryPolicy.class);
    @VisibleForTesting
    public static final String VERDICT_ON_READ_TIMEOUT = "[{}] Verdict on read timeout (consistency: {}, required responses: {}, received responses: {}, data retrieved: {}, retries: {}): {}";
    @VisibleForTesting
    public static final String VERDICT_ON_WRITE_TIMEOUT = "[{}] Verdict on write timeout (consistency: {}, write type: {}, required acknowledgments: {}, received acknowledgments: {}, retries: {}): {}";
    @VisibleForTesting
    public static final String VERDICT_ON_UNAVAILABLE = "[{}] Verdict on unavailable exception (consistency: {}, required replica: {}, alive replica: {}, retries: {}): {}";
    @VisibleForTesting
    public static final String VERDICT_ON_ABORTED = "[{}] Verdict on aborted request (type: {}, message: '{}', retries: {}): {}";
    @VisibleForTesting
    public static final String VERDICT_ON_ERROR = "[{}] Verdict on node error (type: {}, message: '{}', retries: {}): {}";
    private final String logPrefix;

    public ConsistencyDowngradingRetryPolicy(@NonNull DriverContext context, @NonNull String profileName) {
        this(context.getSessionName() + "|" + profileName);
    }

    public ConsistencyDowngradingRetryPolicy(@NonNull String logPrefix) {
        this.logPrefix = logPrefix;
    }

    @Override
    public RetryVerdict onReadTimeoutVerdict(@NonNull Request request, @NonNull ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        RetryVerdict verdict = retryCount != 0 ? RetryVerdict.RETHROW : (cl.isSerial() ? RetryVerdict.RETHROW : (received < blockFor ? this.maybeDowngrade(received, cl) : (!dataPresent ? RetryVerdict.RETRY_SAME : RetryVerdict.RETHROW)));
        if (LOG.isTraceEnabled()) {
            LOG.trace(VERDICT_ON_READ_TIMEOUT, new Object[]{this.logPrefix, cl, blockFor, received, dataPresent, retryCount, verdict});
        }
        return verdict;
    }

    @Override
    public RetryVerdict onWriteTimeoutVerdict(@NonNull Request request, @NonNull ConsistencyLevel cl, @NonNull WriteType writeType, int blockFor, int received, int retryCount) {
        RetryVerdict verdict = retryCount != 0 ? RetryVerdict.RETHROW : (WriteType.SIMPLE.equals(writeType) || WriteType.BATCH.equals(writeType) ? (received > 0 ? RetryVerdict.IGNORE : RetryVerdict.RETHROW) : (WriteType.UNLOGGED_BATCH.equals(writeType) ? this.maybeDowngrade(received, cl) : (WriteType.BATCH_LOG.equals(writeType) ? RetryVerdict.RETRY_SAME : RetryVerdict.RETHROW)));
        if (LOG.isTraceEnabled()) {
            LOG.trace(VERDICT_ON_WRITE_TIMEOUT, new Object[]{this.logPrefix, cl, writeType, blockFor, received, retryCount, verdict});
        }
        return verdict;
    }

    @Override
    public RetryVerdict onUnavailableVerdict(@NonNull Request request, @NonNull ConsistencyLevel cl, int required, int alive, int retryCount) {
        RetryVerdict verdict = retryCount != 0 ? RetryVerdict.RETHROW : (cl.isSerial() ? RetryVerdict.RETRY_NEXT : this.maybeDowngrade(alive, cl));
        if (LOG.isTraceEnabled()) {
            LOG.trace(VERDICT_ON_UNAVAILABLE, new Object[]{this.logPrefix, cl, required, alive, retryCount, verdict});
        }
        return verdict;
    }

    @Override
    public RetryVerdict onRequestAbortedVerdict(@NonNull Request request, @NonNull Throwable error, int retryCount) {
        RetryVerdict verdict;
        RetryVerdict retryVerdict = verdict = error instanceof ClosedConnectionException || error instanceof HeartbeatException ? RetryVerdict.RETRY_NEXT : RetryVerdict.RETHROW;
        if (LOG.isTraceEnabled()) {
            LOG.trace(VERDICT_ON_ABORTED, new Object[]{this.logPrefix, error.getClass().getSimpleName(), error.getMessage(), retryCount, verdict});
        }
        return verdict;
    }

    @Override
    public RetryVerdict onErrorResponseVerdict(@NonNull Request request, @NonNull CoordinatorException error, int retryCount) {
        RetryVerdict verdict;
        RetryVerdict retryVerdict = verdict = error instanceof WriteFailureException || error instanceof ReadFailureException ? RetryVerdict.RETHROW : RetryVerdict.RETRY_NEXT;
        if (LOG.isTraceEnabled()) {
            LOG.trace(VERDICT_ON_ERROR, new Object[]{this.logPrefix, error.getClass().getSimpleName(), error.getMessage(), retryCount, verdict});
        }
        return verdict;
    }

    @Override
    @Deprecated
    public RetryDecision onReadTimeout(@NonNull Request request, @NonNull ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        throw new UnsupportedOperationException("onReadTimeout");
    }

    @Override
    @Deprecated
    public RetryDecision onWriteTimeout(@NonNull Request request, @NonNull ConsistencyLevel cl, @NonNull WriteType writeType, int blockFor, int received, int retryCount) {
        throw new UnsupportedOperationException("onWriteTimeout");
    }

    @Override
    @Deprecated
    public RetryDecision onUnavailable(@NonNull Request request, @NonNull ConsistencyLevel cl, int required, int alive, int retryCount) {
        throw new UnsupportedOperationException("onUnavailable");
    }

    @Override
    @Deprecated
    public RetryDecision onRequestAborted(@NonNull Request request, @NonNull Throwable error, int retryCount) {
        throw new UnsupportedOperationException("onRequestAborted");
    }

    @Override
    @Deprecated
    public RetryDecision onErrorResponse(@NonNull Request request, @NonNull CoordinatorException error, int retryCount) {
        throw new UnsupportedOperationException("onErrorResponse");
    }

    @Override
    public void close() {
    }

    private RetryVerdict maybeDowngrade(int alive, ConsistencyLevel current) {
        if (alive >= 3) {
            return new ConsistencyDowngradingRetryVerdict(ConsistencyLevel.THREE);
        }
        if (alive == 2) {
            return new ConsistencyDowngradingRetryVerdict(ConsistencyLevel.TWO);
        }
        if (alive == 1 || current.getProtocolCode() == ConsistencyLevel.EACH_QUORUM.getProtocolCode()) {
            return new ConsistencyDowngradingRetryVerdict(ConsistencyLevel.ONE);
        }
        return RetryVerdict.RETHROW;
    }
}

