/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class StreamIdGenerator {
    private final int maxAvailableIds;
    private final BitSet ids;
    private AtomicInteger availableIds;

    StreamIdGenerator(int maxAvailableIds) {
        this.maxAvailableIds = maxAvailableIds;
        this.ids = new BitSet(this.maxAvailableIds);
        this.availableIds = new AtomicInteger(this.maxAvailableIds);
    }

    boolean preAcquire() {
        int current;
        do {
            current = this.availableIds.get();
            assert (current >= 0);
            if (current != 0) continue;
            return false;
        } while (!this.availableIds.compareAndSet(current, current - 1));
        return true;
    }

    void cancelPreAcquire() {
        int available = this.availableIds.incrementAndGet();
        assert (available <= this.maxAvailableIds);
    }

    int acquire() {
        assert (this.availableIds.get() < this.maxAvailableIds);
        int id = this.ids.nextClearBit(0);
        if (id >= this.maxAvailableIds) {
            return -1;
        }
        this.ids.set(id);
        return id;
    }

    void release(int id) {
        if (!this.ids.get(id)) {
            throw new IllegalStateException("Tried to release id that hadn't been borrowed: " + id);
        }
        this.ids.clear(id);
        int available = this.availableIds.incrementAndGet();
        assert (available <= this.maxAvailableIds);
    }

    int getAvailableIds() {
        return this.availableIds.get();
    }

    int getMaxAvailableIds() {
        return this.maxAvailableIds;
    }
}

