/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ListMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.MultimapBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflection {
    private static final Logger LOG = LoggerFactory.getLogger(Reflection.class);

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            ClassLoader cl;
            ClassLoader classLoader2 = cl = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return Class.forName(className, true, cl);
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <ComponentT> Optional<ComponentT> buildFromConfig(InternalDriverContext context, DriverOption classNameOption, Class<ComponentT> expectedSuperType, String ... defaultPackages) {
        return Reflection.buildFromConfig(context, null, classNameOption, expectedSuperType, defaultPackages);
    }

    public static <ComponentT> Map<String, ComponentT> buildFromConfigProfiles(InternalDriverContext context, DriverOption rootOption, Class<ComponentT> expectedSuperType, String ... defaultPackages) {
        ListMultimap profilesByConfig = MultimapBuilder.hashKeys().arrayListValues().build();
        for (DriverExecutionProfile driverExecutionProfile : context.getConfig().getProfiles().values()) {
            profilesByConfig.put(driverExecutionProfile.getComparisonKey(rootOption), (Object)driverExecutionProfile.getName());
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Collection profiles : profilesByConfig.asMap().values()) {
            String profileName = (String)profiles.iterator().next();
            ComponentT policy = Reflection.buildFromConfig(context, profileName, Reflection.classOption(rootOption), expectedSuperType, defaultPackages).orElseThrow(() -> new IllegalArgumentException(String.format("Missing configuration for %s in profile %s", rootOption.getPath(), profileName)));
            for (String profile : profiles) {
                result.put((Object)profile, policy);
            }
        }
        return result.build();
    }

    public static <ComponentT> Optional<ComponentT> buildFromConfig(InternalDriverContext context, String profileName, DriverOption classNameOption, Class<ComponentT> expectedSuperType, String ... defaultPackages) {
        Constructor<ComponentT> constructor;
        Object[] objectArray;
        DriverExecutionProfile config = profileName == null ? context.getConfig().getDefaultProfile() : context.getConfig().getProfile(profileName);
        String configPath = classNameOption.getPath();
        LOG.debug("Creating a {} from config option {}", (Object)expectedSuperType.getSimpleName(), (Object)configPath);
        if (!config.isDefined(classNameOption)) {
            LOG.debug("Option is not defined, skipping");
            return Optional.empty();
        }
        String className = config.getString(classNameOption);
        Class<?> clazz = null;
        if (className.contains(".")) {
            LOG.debug("Building from fully-qualified name {}", (Object)className);
            clazz = Reflection.loadClass(context.getClassLoader(), className);
        } else {
            LOG.debug("Building from unqualified name {}", (Object)className);
            for (String defaultPackage : defaultPackages) {
                String qualifiedClassName = defaultPackage + "." + className;
                LOG.debug("Trying with default package {}", (Object)qualifiedClassName);
                clazz = Reflection.loadClass(context.getClassLoader(), qualifiedClassName);
                if (clazz != null) break;
            }
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Can't find class %s (specified by %s)", className, configPath));
        }
        Preconditions.checkArgument((boolean)expectedSuperType.isAssignableFrom(clazz), (String)"Expected class %s (specified by %s) to be a subtype of %s", (Object)className, (Object)configPath, (Object)expectedSuperType.getName());
        if (profileName == null) {
            Object[] objectArray2 = new Class[1];
            objectArray = objectArray2;
            objectArray2[0] = DriverContext.class;
        } else {
            Class[] classArray = new Class[2];
            classArray[0] = DriverContext.class;
            objectArray = classArray;
            classArray[1] = String.class;
        }
        Object[] argumentTypes = objectArray;
        try {
            constructor = clazz.asSubclass(expectedSuperType).getConstructor((Class<?>[])argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Expected class %s (specified by %s) to have an accessible constructor with arguments (%s)", className, configPath, Joiner.on((char)',').join(argumentTypes)));
        }
        try {
            ComponentT instance = profileName == null ? constructor.newInstance(context) : constructor.newInstance(context, profileName);
            return Optional.of(instance);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            throw new IllegalArgumentException(String.format("Error instantiating class %s (specified by %s): %s", className, configPath, cause.getMessage()), cause);
        }
    }

    private static DriverOption classOption(DriverOption rootOption) {
        return () -> rootOption.getPath() + ".class";
    }
}

