/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultColumnMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultViewMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RawColumn;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ViewParser
extends RelationParser {
    private static final Logger LOG = LoggerFactory.getLogger(ViewParser.class);

    public ViewParser(SchemaRows rows, InternalDriverContext context) {
        super(rows, context);
    }

    public ViewMetadata parseView(AdminRow viewRow, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes) {
        Map<CqlIdentifier, Object> options;
        CqlIdentifier viewId = CqlIdentifier.fromInternal(viewRow.getString("view_name"));
        UUID uuid = viewRow.getUuid("id");
        CqlIdentifier baseTableId = CqlIdentifier.fromInternal(viewRow.getString("base_table_name"));
        boolean includesAllColumns = (Boolean)MoreObjects.firstNonNull((Object)viewRow.getBoolean("include_all_columns"), (Object)false);
        String whereClause = viewRow.getString("where_clause");
        List<RawColumn> rawColumns = RawColumn.toRawColumns(this.rows.columns().getOrDefault(keyspaceId, (Multimap<CqlIdentifier, AdminRow>)ImmutableMultimap.of()).get((Object)viewId), keyspaceId, userTypes);
        if (rawColumns.isEmpty()) {
            LOG.warn("[{}] Processing VIEW refresh for {}.{} but found no matching rows, skipping", new Object[]{this.logPrefix, keyspaceId, viewId});
            return null;
        }
        Collections.sort(rawColumns);
        ImmutableMap.Builder allColumnsBuilder = ImmutableMap.builder();
        ImmutableList.Builder partitionKeyBuilder = ImmutableList.builder();
        ImmutableMap.Builder clusteringColumnsBuilder = ImmutableMap.builder();
        for (RawColumn raw : rawColumns) {
            DataType dataType = this.rows.dataTypeParser().parse(keyspaceId, raw.dataType, userTypes, this.context);
            DefaultColumnMetadata column = new DefaultColumnMetadata(keyspaceId, viewId, raw.name, dataType, raw.kind.equals("static"));
            switch (raw.kind) {
                case "partition_key": {
                    partitionKeyBuilder.add((Object)column);
                    break;
                }
                case "clustering": {
                    clusteringColumnsBuilder.put((Object)column, (Object)(raw.reversed ? ClusteringOrder.DESC : ClusteringOrder.ASC));
                    break;
                }
            }
            allColumnsBuilder.put((Object)column.getName(), (Object)column);
        }
        try {
            options = this.parseOptions(viewRow);
        }
        catch (Exception e) {
            Loggers.warnWithException(LOG, "[{}] Error while parsing options for {}.{}, getOptions() will be empty", this.logPrefix, keyspaceId, viewId, e);
            options = Collections.emptyMap();
        }
        return new DefaultViewMetadata(keyspaceId, viewId, baseTableId, includesAllColumns, whereClause, uuid, (ImmutableList<ColumnMetadata>)partitionKeyBuilder.build(), (ImmutableMap<ColumnMetadata, ClusteringOrder>)clusteringColumnsBuilder.build(), (ImmutableMap<CqlIdentifier, ColumnMetadata>)allColumnsBuilder.build(), options);
    }
}

