/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.util.ProtocolUtils;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class ChannelHandlerRequest
implements ResponseCallback {
    final Channel channel;
    final ChannelHandlerContext ctx;
    private final long timeoutMillis;
    private ScheduledFuture<?> timeoutFuture;

    ChannelHandlerRequest(ChannelHandlerContext ctx, long timeoutMillis) {
        this.ctx = ctx;
        this.channel = ctx.channel();
        this.timeoutMillis = timeoutMillis;
    }

    abstract String describe();

    abstract Message getRequest();

    abstract void onResponse(Message var1);

    abstract void fail(String var1, Throwable var2);

    void fail(Throwable cause) {
        this.fail(null, cause);
    }

    void send() {
        assert (this.channel.eventLoop().inEventLoop());
        DriverChannel.RequestMessage message = new DriverChannel.RequestMessage(this.getRequest(), false, Frame.NO_PAYLOAD, this);
        ChannelFuture writeFuture = this.channel.writeAndFlush((Object)message);
        writeFuture.addListener(this::writeListener);
    }

    private void writeListener(Future<? super Void> writeFuture) {
        if (writeFuture.isSuccess()) {
            this.timeoutFuture = this.channel.eventLoop().schedule(this::onTimeout, this.timeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            this.fail(this.describe() + ": error writing ", writeFuture.cause());
        }
    }

    @Override
    public final void onResponse(Frame responseFrame) {
        this.timeoutFuture.cancel(true);
        this.onResponse(responseFrame.message);
    }

    @Override
    public final void onFailure(Throwable error) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        this.fail(this.describe() + ": unexpected failure", error);
    }

    private void onTimeout() {
        this.fail(new DriverTimeoutException(this.describe() + ": timed out after " + this.timeoutMillis + " ms"));
        if (!this.channel.closeFuture().isDone()) {
            this.channel.writeAndFlush((Object)this).addListener(UncaughtExceptions::log);
        }
    }

    void failOnUnexpected(Message response) {
        if (response instanceof Error) {
            Error error = (Error)response;
            this.fail(new IllegalArgumentException(String.format("%s: unexpected server error [%s] %s", this.describe(), ProtocolUtils.errorCodeString(error.code), error.message)));
        } else {
            this.fail(new IllegalArgumentException(String.format("%s: unexpected server response opcode=%s", this.describe(), ProtocolUtils.opcodeString(response.opcode))));
        }
    }
}

