/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.auth;

import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.Authenticator;
import com.datastax.oss.driver.api.core.auth.SyncAuthenticator;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class PlainTextAuthProviderBase
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextAuthProviderBase.class);
    private final String logPrefix;

    protected PlainTextAuthProviderBase(@NonNull String logPrefix) {
        this.logPrefix = Objects.requireNonNull(logPrefix);
    }

    @NonNull
    protected abstract Credentials getCredentials();

    @Override
    @NonNull
    public Authenticator newAuthenticator(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) {
        return new PlainTextAuthenticator(this.getCredentials());
    }

    @Override
    public void onMissingChallenge(@NonNull EndPoint endPoint) {
        LOG.warn("[{}] {} did not send an authentication challenge; This is suspicious because the driver expects authentication", (Object)this.logPrefix, (Object)endPoint);
    }

    @Override
    public void close() {
    }

    protected static class PlainTextAuthenticator
    implements SyncAuthenticator {
        private final ByteBuffer initialToken;

        protected PlainTextAuthenticator(@NonNull Credentials credentials) {
            Objects.requireNonNull(credentials);
            ByteBuffer usernameBytes = this.toUtf8Bytes(credentials.getUsername());
            ByteBuffer passwordBytes = this.toUtf8Bytes(credentials.getPassword());
            credentials.clear();
            this.initialToken = ByteBuffer.allocate(usernameBytes.remaining() + passwordBytes.remaining() + 2);
            this.initialToken.put((byte)0);
            this.initialToken.put(usernameBytes);
            this.initialToken.put((byte)0);
            this.initialToken.put(passwordBytes);
            this.initialToken.flip();
            usernameBytes.rewind();
            while (usernameBytes.remaining() > 0) {
                usernameBytes.put((byte)0);
            }
            passwordBytes.rewind();
            while (passwordBytes.remaining() > 0) {
                passwordBytes.put((byte)0);
            }
        }

        private ByteBuffer toUtf8Bytes(char[] charArray) {
            CharBuffer charBuffer = CharBuffer.wrap(charArray);
            return Charsets.UTF_8.encode(charBuffer);
        }

        @Override
        @Nullable
        public ByteBuffer initialResponseSync() {
            return this.initialToken.duplicate();
        }

        @Override
        @Nullable
        public ByteBuffer evaluateChallengeSync(@Nullable ByteBuffer token) {
            return null;
        }

        @Override
        public void onAuthenticationSuccessSync(@Nullable ByteBuffer token) {
        }
    }

    protected static class Credentials {
        private final char[] username;
        private final char[] password;

        public Credentials(@NonNull char[] username, @NonNull char[] password) {
            this.username = Objects.requireNonNull(username);
            this.password = Objects.requireNonNull(password);
        }

        @NonNull
        public char[] getUsername() {
            return this.username;
        }

        @NonNull
        public char[] getPassword() {
            return this.password;
        }

        protected void clear() {
            Arrays.fill(this.getUsername(), '\u0000');
            Arrays.fill(this.getPassword(), '\u0000');
        }
    }
}

